/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.util;

import java.util.Stack;

/**
 * CycleDetector
 */
public class CycleDetector {
	private static ThreadLocal<Stack<Object>> context = new ThreadLocal<Stack<Object>>();
	
	private static Stack<Object> getStack() {
		Stack<Object> stack = context.get();
		if (stack == null) {
			stack = new Stack<Object>();
			context.set(stack);
		}
		return stack;
	}
	
	/**
	 * push a object to the stack
	 * @param object object
	 */
	public static void push(Object object) {
		getStack().push(object);
	}
	
	/**
	 * pop the top object out of the stack
	 * @return popup object
	 */
	public static Object pop() {
		return getStack().pop();
	}

	/**
	 * @param object object
	 * @return true if the object is in the stack
	 */
	public static boolean contains(Object object) {
		return getStack().contains(object);
	}
}
