/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.util;

import nuts.core.bind.json.Jsons;

import java.io.Serializable;

/**
 * base bean object
 */
public abstract class BeanObject implements Cloneable, Serializable {
	/**
	 * serialVersionUID
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * Clone
	 * @throws CloneNotSupportedException if clone not supported
	 * @return Clone Object
	 */
	public Object clone() throws CloneNotSupportedException {
		return super.clone();
	}

	/**
	 * @return a string representation of the object.
	 */
	public String toString() {
		return super.toString() + ":" + Jsons.toJson(this, true);
	}
	
	/**
	 * to string
	 * @param obj object
	 * @return json string
	 */
	public static String toString(Object obj) {
		if (obj == null) {
			return String.valueOf(obj);
		}
		return obj.toString() + ":" + Jsons.toJson(obj, true);
	}
}
