/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.taskqueue;

import java.util.HashMap;
import java.util.Map;

public class TaskQueueFactory {
	private static TaskQueueFactory instance = new TaskQueueFactory();
	
	private Map<String, TaskQueue> queues;

	/**
	 * @return the instance
	 */
	public static TaskQueueFactory getInstance() {
		return instance;
	}

	/**
	 * @param instance the instance to set
	 */
	public static void setInstance(TaskQueueFactory instance) {
		TaskQueueFactory.instance = instance;
	}

	public TaskQueueFactory() {
		queues = new HashMap<String, TaskQueue>();
		queues.put(TaskQueue.DEFAULT_QUEUE, new TaskQueue(TaskQueue.DEFAULT_QUEUE));
	}
	
	public TaskQueue getDefaultQueue() {
		return getQueue(TaskQueue.DEFAULT_QUEUE);
	}
	
	public TaskQueue getQueue(String name) {
		return queues.get(name);
	}
}
