/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.resource;

import java.util.Enumeration;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;

/**
 * resource bundle for map
 */
public class MapResourceBundle extends ResourceBundle {
	/**
	 * contents map
	 */
	protected Map<String, Object> contents;

	/**
	 * @return the contents
	 */
	public Map<String, Object> getContents() {
		return contents;
	}

	/**
	 * @param contents the contents to set
	 */
	public void setContents(Map<String, Object> contents) {
		this.contents = contents;
	}

	/**
	 * Constructor.
	 */
	public MapResourceBundle() {
		
	}
	
	/**
	 * Constructor
	 * @param map content map
	 */
	public MapResourceBundle(Map<String, Object> map) {
		setContents(map);
	}
	
	/**
	 * Returns an <code>Enumeration</code> of the keys contained in
	 * this <code>ResourceBundle</code> and its parent bundles.
	 *
	 * @return an <code>Enumeration</code> of the keys contained in
	 *         this <code>ResourceBundle</code> and its parent bundles.
	 */
	public Enumeration<String> getKeys() {
		ResourceBundle parent = this.parent;
		return new ResourceBundleEnumeration(getContents().keySet(),
				(parent != null) ? parent.getKeys() : null);
	}

	/**
	 * @see java.util.ResourceBundle#handleGetObject(java.lang.String)
	 */
	protected Object handleGetObject(String key) {
		if (key == null) {
			throw new NullPointerException();
		}
		return getContents().get(key);
	}

	/**
	 * Returns a <code>Set</code> of the keys contained
	 * <em>only</em> in this <code>ResourceBundle</code>.
	 *
	 * @return a <code>Set</code> of the keys contained only in this
	 *         <code>ResourceBundle</code>
	 * @see #keySet()
	 */
	protected Set<String> handleKeySet() {
		return getContents().keySet();
	}
}
