/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.log;

public interface Log {

	Log setTag(String tag);

	boolean isFatalEnabled();

	void fatal(Object message);

	void fatalf(String fmt, Object... args);

	void fatal(Object message, Throwable t);

	boolean isErrorEnabled();

	void error(Object message);

	void errorf(String fmt, Object... args);

	void error(Object message, Throwable t);

	boolean isWarnEnabled();

	void warn(Object message);

	void warnf(String fmt, Object... args);

	void warn(Object message, Throwable t);

	boolean isInfoEnabled();

	void info(Object message);

	void infof(String fmt, Object... args);

	void info(Object message, Throwable t);

	boolean isDebugEnabled();

	void debug(Object message);

	void debugf(String fmt, Object... args);

	void debug(Object message, Throwable t);

	boolean isTraceEnabled();

	void trace(Object message);

	void tracef(String fmt, Object... args);

	void trace(Object message, Throwable t);
}
