/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.lang.i18n.chardet ;


public abstract class nsVerifier {

     static final byte eStart = (byte)0;
     static final byte eError = (byte)1;
     static final byte eItsMe = (byte)2;
     static final int eidxSft4bits = 3;
     static final int eSftMsk4bits = 7;
     static final int eBitSft4bits = 2;
     static final int eUnitMsk4bits = 0x0000000F;

     nsVerifier() {
     }

     public abstract String charset() ;
     public abstract int stFactor()   ;
     public abstract int[] cclass()   ;
     public abstract int[] states()   ;

     public abstract boolean isUCS2() ;

     @SuppressWarnings("static-access")
	public static byte getNextState(nsVerifier v, byte b, byte s) {

         return (byte) ( 0xFF & 
	     (((v.states()[((
		   (s*v.stFactor()+(((v.cclass()[((b&0xFF)>>v.eidxSft4bits)]) 
		   >> ((b & v.eSftMsk4bits) << v.eBitSft4bits)) 
		   & v.eUnitMsk4bits ))&0xFF)
		>> v.eidxSft4bits) ]) >> (((
		   (s*v.stFactor()+(((v.cclass()[((b&0xFF)>>v.eidxSft4bits)]) 
		   >> ((b & v.eSftMsk4bits) << v.eBitSft4bits)) 
		   & v.eUnitMsk4bits ))&0xFF) 
		& v.eSftMsk4bits) << v.eBitSft4bits)) & v.eUnitMsk4bits )
	 ) ;

     }


}
