/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.lang.i18n.chardet ;


public class nsDetector extends nsPSMDetector 
			implements nsICharsetDetector {

	nsICharsetDetectionObserver mObserver = null ;

	public nsDetector() {
		super() ;
	}

	public nsDetector(int langFlag) {
		super(langFlag) ;
	}

	public void Init(nsICharsetDetectionObserver aObserver) {

	  	mObserver = aObserver ;
		return ;

	}

	public boolean DoIt(byte[] aBuf, int aLen, boolean oDontFeedMe) {

		if (aBuf == null || oDontFeedMe )
		    return false ;

		this.HandleData(aBuf, aLen) ;	
		return mDone ;
	}

	public void Done() {
		this.DataEnd() ;
		return ;
	}

	public void Report(String charset) {
		if (mObserver != null)
		    mObserver.Notify(charset)  ;
	}

	public boolean isAscii(byte[] aBuf, int aLen) {

                for(int i=0; i<aLen; i++) {
                   if ((0x0080 & aBuf[i]) != 0) {
                      return false ;
                   }
                }
		return true ;
	}
}
