/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.lang.comparator;

import nuts.core.lang.Asserts;

import java.util.Comparator;

/**
 * reverse order comparator
 * @param <T> the type of objects that may be compared by this comparator
 */
public class ReverseComparator<T> implements Comparator<T> {
	private Comparator<T> comparator;
	
	/**
	 * constructor
	 * @param comparator comparator
	 */
	public ReverseComparator(Comparator<T> comparator) {
		Asserts.notNull(comparator);
		this.comparator = comparator;
	}
	
	/**
	 * @param o1 the first object to be compared.
	 * @param o2 the second object to be compared.
	 * @return a negative integer, zero, or a positive integer as the first argument is less than,
	 *         equal to, or greater than the second.
	 * @see java.util.Comparator#compare(java.lang.Object, java.lang.Object)
	 */
	public int compare(T o1, T o2) {
		return - comparator.compare(o1, o2);
	}
}
