/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.lang.comparator;

import nuts.core.lang.Objects;

import java.math.BigDecimal;
import java.util.Comparator;

/**
 * number comparator for string
 */
public class NumericStringComparator implements Comparator<String> {
	
	private int radix;

	/**
	 * constructor
	 * radix = 10
	 */
	public NumericStringComparator() {
		this(10);
	}

	/**
	 * constructor
	 * @param radix radix
	 */
	public NumericStringComparator(int radix) {
		this.radix = radix;
	}
	
	/**
	 * @return radix
	 */
	public int getRadix() {
		return radix;
	}

	/**
	 * @param radix set radix
	 */
	public void setRadix(int radix) {
		this.radix = radix;
	}

	/**
	 * @param o1 string1
	 * @param o2 string2
	 * @return a negative integer, zero, or a positive integer as the first argument is less than,
	 *         equal to, or greater than the second.
	 */
	public int compare(String o1, String o2) {
		BigDecimal n1, n2;
		
		try {
			n1 = new BigDecimal(o1);
		}
		catch (NumberFormatException e) {
			return -1;
		}

		try {
			n2 = new BigDecimal(o2);
		}
		catch (NumberFormatException e) {
			return 1;
		}

		return n1.compareTo(n2);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String toString() {
		return Objects.toStringBuilder(this).append("radix", radix).toString();
	}
	
}
