/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.lang.collection;

import nuts.core.lang.Arrays;

/**
 */
public class MultiKey {
	private final Object[] keys;
	private int hashCode;

	/**
	 * Constructs an instance of <code>MultipartKey</code> to hold the specified objects.
	 * 
	 * @param keys the set of objects that make up the key. Each key may be null.
	 */
	public MultiKey(final Object... keys) {
		this.keys = keys;
		for (final Object key : keys) {
			if (key != null) {
				hashCode = hashCode * 7 + key.hashCode();
			}
		}
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean equals(final Object obj) {
		// Eliminate the usual boilerplate because
		// this inner static class is only used in a generic ConcurrentHashMap
		// which will not compare against other Object types
		return Arrays.equals(keys, ((MultiKey)obj).keys);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public int hashCode() {
		return hashCode;
	}
}
