/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.lang.collection;

import java.util.Map;


/**
 */
public class MapEntry<K, V> extends KeyValue<K, V> {
	protected Map<K, V> map;
	
	/**
	 * Constructs a new pair with the specified key and given value.
	 * 
	 * @param key the key for the entry, may be null
	 * @param value the value for the entry, may be null
	 */
	public MapEntry(Map<K, V> map, K key, V value) {
		super(key, value);
		this.map = map;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public V setValue(V value) {
		this.value = value;
		return map.put(key, value);
	}
}
