/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.lang.codec;

/**
 * Defines common encoding methods for byte array encoders.
 * 
 */
public interface BinaryEncoder {
	/**
	 * Encodes a byte array and return the encoded data as a byte array.
	 * 
	 * @param pArray Data to be encoded
	 * @return A byte array containing the encoded data
	 * @throws EncoderException thrown if the Encoder encounters a failure condition during the
	 *             encoding process.
	 */
	byte[] encode(byte[] pArray) throws EncoderException;
}  

