/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.lang.codec;

/**
 * Defines common decoding methods for byte array decoders.
 *
 */
public interface BinaryDecoder {
	/**
	 * Decodes a byte array and returns the results as a byte array.
	 * 
	 * @param pArray A byte array which has been encoded with the appropriate encoder
	 * @return a byte array that contains decoded content
	 * @throws DecoderException A decoder exception is thrown if a Decoder encounters a failure
	 *             condition during the decode process.
	 */
	byte[] decode(byte[] pArray) throws DecoderException;
}
