/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.lang;

import nuts.core.lang.codec.binary.Base64;

/**
 */
public class StringEncrypts {

	public static String DEFAULT_TRANSFORM = Encrypts.ENCRYPT_Blowfish;

	public static String DEFAULT_KEY = "nuts";

	public static String encrypt(String text) {
		return encrypt(text, DEFAULT_KEY, DEFAULT_TRANSFORM);
	}

	public static String decrypt(String text) {
		return decrypt(text, DEFAULT_KEY, DEFAULT_TRANSFORM);
	}
	
	public static String encrypt(String text, String key) {
		return encrypt(text, key, DEFAULT_TRANSFORM);
	}

	public static String decrypt(String text, String key) {
		return decrypt(text, key, DEFAULT_TRANSFORM);
	}
	
	public static String encrypt(String text, String key, String transform) {
		byte[] t = Strings.getBytesUtf8(text);
		byte[] k = Strings.getBytesUtf8(key);
		byte[] encrypted = Encrypts.encrypt(t, k, transform);
		return Strings.newStringUtf8(Base64.encodeBase64(encrypted, false, false));
	}

	public static String decrypt(String text, String key, String transform) {
		byte[] t = Base64.decodeBase64(text);
		byte[] k = Strings.getBytesUtf8(key);
		byte[] decrypted = Encrypts.decrypt(t, k, transform);
		return Strings.newStringUtf8(decrypted);
	}
}
