/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.lang;


import java.util.ArrayList;
import java.util.List;


/**
 */
public class CycleDetector {
	/** cycle detect value stack */
	private List<Object> stack = new ArrayList<Object>();

	/** cycle detect name stack */
	private List<String> names = new ArrayList<String>();


	public void push(String name, Object value) {
		names.add(name);
		stack.add(value);
	}
	public void popup() {
		names.remove(names.size() - 1);
		stack.remove(stack.size() - 1);
	}
	public boolean isCycled(Object value) {
		return stack.contains(value);
	}
	
	public String toPath() {
		return '/' + Strings.join(names, "/");
	}
	
	public String toPath(String name) {
		return toPath() + '/' + name;
	}
}
