/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.image;


/**
 */
public abstract class Images {
	private static Images me = new JavaImages();
	
	/**
	 * @return the instance
	 */
	public static Images me() {
		return me;
	}

	/**
	 * @return the instance
	 */
	public static Images getMe() {
		return me;
	}

	/**
	 * @param instance the instance to set
	 */
	public static void setMe(Images instance) {
		Images.me = instance;
	}

	public abstract ImageWrapper makeImage(byte[] data) throws Exception;
}
