/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.dao.sql.engine;



/**
 * ExtendSqlExecutor (extends from SimpleSqlExecutor).
 * 
 * <pre>
 * Dynamic SQL: 
 *    &#64; --> (at mark) at something
 *    &#64;!  --> not at something
 * 
 *    1) SELECT * FROM SAMPLE
 *         &#64;[ WHERE
 *           &#64;[(&#64;id[ID=:id] &#64;name[OR NAME=:name] &#64;bool[OR BOOL=:bool])]
 *           &#64;list[AND LIST IN (:list)]
 *           &#64;kind[AND KIND=:kind]
 *           &#64;!kind[AND KIND IS NULL]
 *         ]
 *         &#64;orderCol[ ORDER BY ::orderCol ::orderDir ]
 * 
 *    descripton:
 *      &#64;id[ID=:id] --> append sql when id is not null
 *      &#64;bool[BOOL=:bool] --> append sql when bool is TRUE
 *      &#64;list[LIST IN (:list)]  --> append sql when list != null && list.size() > 0 (:list --> ?, ?, ?)
 *      &#64;[ WHERE ... ]  --> append sql when all the logical expression in &#64;[...] is true
 *      &#64;!kind[AND KIND IS NULL] --> append sql when kind is null
 * 
 *    2) UPDATE SAMPLE
 *         SET
 *           &#64;name[,NAME=:name]
 *           &#64;kind[,KIND=:kind]
 *           ,OTHER='@kind[,KIND=:kind]'
 *         WHERE
 *           ID=:id
 *
 *
 * @see SimpleSqlExecutor
 * 
 * </pre>
 */
public class ExtendSqlExecutor extends SimpleSqlExecutor {
	/**
	 * Constructor
	 * @param sqlManager sqlManager
	 */
	protected ExtendSqlExecutor(ExtendSqlManager sqlManager) {
		super(sqlManager);
	}

	/**
	 * createSqlParser
	 * @param sql sql
	 * @return SqlParser instance
	 */
	@Override
	protected SqlParser createSqlParser(String sql) {
		return new ExtendSqlParser(sql);
	}
}
