/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.dao.sql.criteria;

import java.util.List;

import nuts.core.dao.Conditions;
import nuts.core.dao.Orders;
import nuts.core.dao.SimpleQueryParameter;

/**
 */
@SuppressWarnings("serial")
public class SqlQueryParameter extends SimpleQueryParameter {
	/**
	 * Constructor
	 */
	public SqlQueryParameter() {
		super();
	}

	/**
	 * Constructor
	 * @param qp query parameter
	 */
	public SqlQueryParameter(SqlQueryParameter qp) {
		super(qp);
	}

	/**
	 * @return conditions
	 */
	public Conditions getConditions() {
		if (conditions == null) {
			conditions = new SqlConditions();
		}
		return conditions;
	}

	/**
	 * @return conditions
	 */
	public SqlConditions getSqlConditions() {
		return (SqlConditions)getConditions();
	}

	/**
	 * @return orders
	 */
	public Orders getOrders() {
		if (orders == null) {
			orders = new SqlOrders();
		}
		return orders;
	}

	/**
	 * @return orders
	 */
	public SqlOrders getSqlOrders() {
		return (SqlOrders)getOrders();
	}

	/**
	 * clear
	 */
	public void clear() {
		if (orders != null) {
			((SqlOrders)orders).clear();
		}
		if (conditions != null) {
			((SqlConditions)conditions).clear();
		}
		if (excludes != null) {
			excludes.clear();
		}
		start = null;
		limit = null;
	}

	//-------------------------------------------------------------------------
	// shortcut
	//-------------------------------------------------------------------------
	/**
	 * @return orderExpressions
	 */
	public List<OrderExpression> getOrderExpressions() {
		return orders == null ? null : getSqlOrders().getExpressions();
	}

	/**
	 * @return restrictionExpressions
	 */
	public List<AbstractExpression> getRestrictionExpressions() {
		return conditions == null ? null : getSqlConditions().getExpressions();
	}

}
