/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.dao.sql.criteria;


/**
 * CompareColumnExpression
 */
@SuppressWarnings("serial")
public class CompareColumnExpression extends SimpleExpression {

	protected String compareColumn;

	/**
	 * @return the compareColumn
	 */
	public String getCompareColumn() {
		return compareColumn;
	}

	/**
	 * @param compareColumn the compareColumn to set
	 */
	public void setCompareColumn(String compareColumn) {
		checkColumn(compareColumn);
		this.compareColumn = compareColumn;
	}

	/**
	 * Constructor
	 * @param column			column
	 * @param condition			condition
	 * @param compareColumn		compareColumn
	 */
	public CompareColumnExpression(String column, String condition, String compareColumn) {
		super(column, condition);
		setCompareColumn(compareColumn);
	}

	/**
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = super.hashCode();
		result = prime * result + ((compareColumn == null) ? 0 : compareColumn.hashCode());
		return result;
	}

	/**
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (!super.equals(obj))
			return false;
		if (getClass() != obj.getClass())
			return false;
		CompareColumnExpression other = (CompareColumnExpression) obj;
		if (compareColumn == null) {
			if (other.compareColumn != null)
				return false;
		}
		else if (!compareColumn.equals(other.compareColumn))
			return false;
		return true;
	}


	/**
     * @return  a string representation of the object.
	 */
	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder();

		sb.append("{ ");
		sb.append(super.toString());
		sb.append(", ");
		sb.append("compareColumn: ").append(compareColumn);
		sb.append(" }");

		return sb.toString();
	}
}
