/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.dao.sql;

import nuts.core.bean.Beans;
import nuts.core.dao.sql.adapter.TypeHandlers;
import nuts.core.dao.sql.engine.ExtendSqlManager;

import java.sql.Connection;
import java.sql.ResultSet;


/**
 */
public abstract class SqlManager {
	private static SqlManager me = new ExtendSqlManager();

	/**
	 * @return the me
	 */
	public static SqlManager me() {
		return me;
	}

	/**
	 * @return the me
	 */
	public static SqlManager getMe() {
		return me;
	}

	/**
	 * @param me the me to set
	 */
	public static void setMe(SqlManager me) {
		SqlManager.me = me;
	}
	
	/**
	 * Beans
	 */
	protected Beans beans = Beans.me();

	/**
	 * typeHandlers
	 */
	protected TypeHandlers typeHandlers = TypeHandlers.me();
	
	/**
	 * @return the beans
	 */
	public Beans getBeans() {
		return beans;
	}

	/**
	 * @param beans the beans to set
	 */
	public void setBeans(Beans beans) {
		this.beans = beans;
	}

	/**
	 * @return the typeHandlers
	 */
	public TypeHandlers getTypeHandlers() {
		return typeHandlers;
	}

	/**
	 * @param typeHandlers the typeHandlers to set
	 */
	public void setTypeHandlers(TypeHandlers typeHandlers) {
		this.typeHandlers = typeHandlers;
	}

	/**
	 * Constructor
	 */
	public SqlExecutor getExecutor() {
		return getExecutor(null, ResultSet.TYPE_FORWARD_ONLY, ResultSet.CONCUR_READ_ONLY);
	}

	/**
	 * Constructor
	 * @param connection connection
	 */
	public SqlExecutor getExecutor(Connection connection) {
		return getExecutor(connection, ResultSet.TYPE_FORWARD_ONLY, ResultSet.CONCUR_READ_ONLY);
	}

	/**
	 * Constructor
	 * 
	 * @param connection connection
	 * @param resultSetType one of the following ResultSet constants: ResultSet.TYPE_FORWARD_ONLY,
	 *            ResultSet.TYPE_SCROLL_INSENSITIVE, or ResultSet.TYPE_SCROLL_SENSITIVE
	 */
	public SqlExecutor getExecutor(Connection connection, int resultSetType) {
		return getExecutor(connection, resultSetType, ResultSet.CONCUR_READ_ONLY);
	}

	/**
	 * Constructor
	 * 
	 * @param connection connection
	 * @param resultSetType one of the following ResultSet constants: ResultSet.TYPE_FORWARD_ONLY,
	 *            ResultSet.TYPE_SCROLL_INSENSITIVE, or ResultSet.TYPE_SCROLL_SENSITIVE
	 * @param resultSetConcurrency one of the following ResultSet constants:
	 *            ResultSet.CONCUR_READ_ONLY or ResultSet.CONCUR_UPDATABLE
	 */
	public SqlExecutor getExecutor(Connection connection, int resultSetType, int resultSetConcurrency) {
		return getExecutor(connection, resultSetType, resultSetConcurrency, 0);
	}

	/**
	 * Constructor
	 * 
	 * @param connection connection
	 * @param resultSetType one of the following ResultSet constants: ResultSet.TYPE_FORWARD_ONLY,
	 *            ResultSet.TYPE_SCROLL_INSENSITIVE, or ResultSet.TYPE_SCROLL_SENSITIVE
	 * @param resultSetConcurrency one of the following ResultSet constants:
	 *            ResultSet.CONCUR_READ_ONLY or ResultSet.CONCUR_UPDATABLE
	 * @param resultSetHoldability one of the following ResultSet constants:
	 *            ResultSet.HOLD_CURSORS_OVER_COMMIT or ResultSet.CLOSE_CURSORS_AT_COMMIT
	 */
	public abstract SqlExecutor getExecutor(Connection connection, int resultSetType, int resultSetConcurrency,
			int resultSetHoldability);
}
