/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.dao.sql;

import nuts.core.lang.Exceptions;
import nuts.core.log.Log;
import nuts.core.log.Logs;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.logging.Logger;

import javax.sql.DataSource;

/**
 * This is a automatic datasource implementation.
 */
public class AutoDataSource implements DataSource {
	private static final Log log = Logs.get();

	private String username;
	private String password;
	protected String driverClassName;
	private String jdbcUrl;

	public AutoDataSource() {
		log.warn("AutoDataSource is use for Test/Attempt, NOT Using in Production environment!");
		log.warn("AutoDataSource is NOT a Connection Pool, So it is slow but safe for debug/study");
	}

	public Connection getConnection() throws SQLException {
		return getConnection(username, password);
	}

	public Connection getConnection(String username, String password) throws SQLException {
		Connection conn;
		if (username != null)
			conn = DriverManager.getConnection(jdbcUrl, username, password);
		else
			conn = DriverManager.getConnection(jdbcUrl);
		return conn;
	}

	public void close() {
	}

	public void setDriverClassName(String driverClassName) throws ClassNotFoundException {
		Class.forName(driverClassName);
	}

	public void setUsername(String username) {
		this.username = username;
	}

	public void setPassword(String password) {
		this.password = password;
	}

	public void setJdbcUrl(String jdbcUrl) {
		this.jdbcUrl = jdbcUrl;
	}

	// add all supported jdbc drivers
	static {
		String[] drivers = { 
				"org.h2.Driver", 
				"com.ibm.db2.jcc.DB2Driver", 
				"org.hsqldb.jdbcDriver",
				"org.gjt.mm.mysql.Driver", 
				"oracle.jdbc.OracleDriver", 
				"org.postgresql.Driver",
				"net.sourceforge.jtds.jdbc.Driver", 
				"com.microsoft.sqlserver.jdbc.SQLServerDriver", 
				"org.sqlite.JDBC"
				};
		for (String driverClassName : drivers) {
			try {
				Class.forName(driverClassName);
			}
			catch (Throwable e) {
			}
		}
	}

	// ---------------------------------------------------------------
	public PrintWriter getLogWriter() throws SQLException {
		throw Exceptions.unsupported();
	}

	public void setLogWriter(PrintWriter out) throws SQLException {
		throw Exceptions.unsupported();
	}

	public void setLoginTimeout(int seconds) throws SQLException {
		throw Exceptions.unsupported();
	}

	public int getLoginTimeout() throws SQLException {
		throw Exceptions.unsupported();
	}

	public <T> T unwrap(Class<T> iface) throws SQLException {
		throw Exceptions.unsupported();
	}

	public boolean isWrapperFor(Class<?> iface) throws SQLException {
		throw Exceptions.unsupported();
	}

	public Logger getParentLogger() {
		throw Exceptions.unsupported();
	}
}
