/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.dao;

import java.util.Map;

/**
 * QueryParameter
 */
public interface QueryParameter {
	/**
	 * @return the excludes
	 */
	Map<String, Boolean> getExcludes();

	/**
	 * @param excludes the excludes to set
	 */
	void setExcludes(Map<String, Boolean> excludes);

	/**
	 * @return true if the excludes is not empty
	 */
	boolean isHasExcludes();

	/**
	 * @param column exclude column
	 * @return this
	 */
	QueryParameter addExclude(String column);

	/**
	 * @param column exclude column
	 * @return this
	 */
	QueryParameter removeExclude(String column);

	/**
	 * clearExcludes
	 * 
	 * @return this
	 */
	QueryParameter clearExcludes();

	/**
	 * @return conditions
	 */
	Conditions getConditions();

	/**
	 * @param conditions the conditions to set
	 */
	void setConditions(Conditions conditions);

	/**
	 * @return orders
	 */
	Orders getOrders();

	/**
	 * @param orders the orders to set
	 */
	void setOrders(Orders orders);

	/**
	 * @return the start
	 */
	Integer getStart();

	/**
	 * @param start the start to set
	 */
	void setStart(Integer start);

	/**
	 * @return the limit
	 */
	Integer getLimit();

	/**
	 * @param limit the limit to set
	 */
	void setLimit(Integer limit);
}