/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.dao;

import nuts.core.dao.sql.SqlConstants;



/**
 * Orders
 */
public interface Orders {
	/**
	 * ASC = "ASC";
	 */
	public static final String ASC = SqlConstants.ASC;
	
	/**
	 * DESC = "DESC";
	 */
	public static final String DESC = SqlConstants.DESC;

	/**
	 * addOrder
	 * @param column		column
	 * @return this
	 */
	Orders addOrder(String column);

	/**
	 * addOrder
	 * @param column		column
	 * @param direction		direction
	 * @return this
	 */
	Orders addOrder(String column, String direction);

	/**
	 * addOrderAsc
	 * @param column column
	 * @return this
	 */
	Orders addOrderAsc(String column);

	/**
	 * addOrderDesc
	 * @param column column
	 * @return this
	 */
	Orders addOrderDesc(String column);
}
