/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.castor.castors;

public class PrimitiveWrapCastor {
	public static class BooleanCastor extends PrimitiveTypeCastor.BooleanCastor {
		public BooleanCastor() {
			super(Boolean.class);
		}

		@Override
		protected Boolean defaultValue() {
			return null;
		}
	}

	public static class ByteCastor extends PrimitiveTypeCastor.ByteCastor {
		public ByteCastor() {
			super(Byte.class);
		}

		@Override
		protected Byte defaultValue() {
			return null;
		}
	}


	public static class CharacterCastor extends PrimitiveTypeCastor.CharacterCastor {
		public CharacterCastor() {
			super(Character.class);
		}

		@Override
		protected Character defaultValue() {
			return null;
		}
	}

	public static class DoubleCastor extends PrimitiveTypeCastor.DoubleCastor {
		public DoubleCastor() {
			super(Double.class);
		}

		@Override
		protected Double defaultValue() {
			return null;
		}
	}

	public static class FloatCastor extends PrimitiveTypeCastor.FloatCastor {
		public FloatCastor() {
			super(Float.class);
		}

		@Override
		protected Float defaultValue() {
			return null;
		}
	}

	public static class IntegerCastor extends PrimitiveTypeCastor.IntegerCastor {
		public IntegerCastor() {
			super(Integer.class);
		}

		@Override
		protected Integer defaultValue() {
			return null;
		}
	}

	public static class LongCastor extends PrimitiveTypeCastor.LongCastor {
		public LongCastor() {
			super(Long.class);
		}

		@Override
		protected Long defaultValue() {
			return null;
		}
	}

	public static class ShortCastor extends PrimitiveTypeCastor.ShortCastor {
		public ShortCastor() {
			super(Short.class);
		}

		@Override
		protected Short defaultValue() {
			return null;
		}
	}


}
