/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.bind.xml;

import nuts.core.bind.Binds;

import java.lang.reflect.Type;


public abstract class Xmls extends Binds {
	public static <T> T fromXml(String xml, Type type) {
		XmlDeserializer xd = new XmlDeserializer();
		return xd.deserialize(xml, type);
	}

	private static XmlSerializer createXmlSerializer() {
		XmlSerializer xs = new XmlSerializer();
		setDefaultSerializerOptions(xs);
		return xs;
	}
	
	public static String toXml(Object value) {
		XmlSerializer xs = createXmlSerializer();
		return xs.serialize(value);
	}

	public static String toXml(Object value, boolean pretty) {
		XmlSerializer xs = createXmlSerializer();
		xs.setPrettyPrint(pretty);
		return xs.serialize(value);
	}

	public static String toXml(Object value, int indent) {
		XmlSerializer xs = createXmlSerializer();
		xs.setIndentFactor(indent);
		return xs.serialize(value);
	}

	public static void toXml(Object value, Appendable writer) {
		XmlSerializer xs = createXmlSerializer();
		xs.serialize(value, writer);
	}

	public static void toXml(Object value, Appendable writer, boolean pretty) {
		XmlSerializer xs = createXmlSerializer();
		xs.setPrettyPrint(pretty);
		xs.serialize(value, writer);
	}

	public static void toXml(Object value, Appendable writer, int indent) {
		XmlSerializer xs = createXmlSerializer();
		xs.setIndentFactor(indent);
		xs.serialize(value, writer);
	}
}
