/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.bind.json;

import nuts.core.bind.Binds;
import nuts.core.lang.Chars;

import java.lang.reflect.Type;


public abstract class Jsons extends Binds {
	public static <T> T fromJson(String json, Type type) {
		JsonDeserializer jd = new JsonDeserializer();
		return jd.deserialize(json, type);
	}

	private static JsonSerializer createJsonSerializer() {
		JsonSerializer js = new JsonSerializer();
		setDefaultSerializerOptions(js);
		return js;
	}
	
	public static String toJson(Object value) {
		JsonSerializer js = createJsonSerializer();
		return js.serialize(value);
	}

	public static String toJson(Object value, boolean pretty) {
		JsonSerializer js = createJsonSerializer();
		js.setPrettyPrint(pretty);
		return js.serialize(value);
	}

	public static String toJson(Object value, int indent) {
		JsonSerializer js = createJsonSerializer();
		js.setIndentChar(Chars.SPACE);
		js.setIndentFactor(indent);
		return js.serialize(value);
	}
	
	public static void toJson(Object value, Appendable writer) {
		JsonSerializer js = createJsonSerializer();
		js.serialize(value, writer);
	}

	public static void toJson(Object value, Appendable writer, boolean pretty) {
		JsonSerializer js = createJsonSerializer();
		js.setPrettyPrint(pretty);
		js.serialize(value, writer);
	}

	public static void toJson(Object value, Appendable writer, int indent) {
		JsonSerializer js = createJsonSerializer();
		js.setIndentChar(Chars.SPACE);
		js.setIndentFactor(indent);
		js.serialize(value, writer);
	}
}
