/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.bind.filters;

import nuts.core.bind.PropertyFilter;
import nuts.core.lang.Strings;

import java.util.ArrayList;
import java.util.List;

/**
 * filter sepecified types when transform to xml 
 */
public class WildcardPropertyFilter implements PropertyFilter {

	private List<String> filterNames;
	private List<String> filterTypes;
	
	/**
	 * Constructor
	 */
	public WildcardPropertyFilter() {
	}

	/**
	 * @return the filterNames
	 */
	public List<String> getFilterNames() {
		if (filterNames == null) {
			filterNames = new ArrayList<String>();
		}
		return filterNames;
	}

	/**
	 * @param filterNames the filterNames to set
	 */
	public void setFilterNames(List<String> filterNames) {
		this.filterNames = filterNames;
	}

	/**
	 * @return the filterTypes
	 */
	public List<String> getFilterTypes() {
		if (filterTypes == null) {
			filterTypes = new ArrayList<String>();
		}
		return filterTypes;
	}

	/**
	 * @param filterTypes the filterTypes to set
	 */
	public void setFilterTypes(List<String> filterTypes) {
		this.filterTypes = filterTypes;
	}

	/**
	 * {@inheritDoc}
	 */
	public boolean accept(Object source, String name, Object value) {
		if (value == null) {
			return false;
		}
		
		if (filterNames != null) {
			for (String s : filterNames) {
				if (Strings.wildcardMatch(name, s)) {
					return false;
				}
			}
		}
		
		if (filterTypes != null) {
			for (String s : filterTypes) {
				if (Strings.wildcardMatch(value.getClass().getName(), s)) {
					return false;
				}
			}
		}

		return true;
	}
	
}
