/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.bind.filters;

import nuts.core.bind.PropertyFilter;

import java.util.ArrayList;
import java.util.List;

public class IncludePropertyFilter implements PropertyFilter {

	protected List<String> includes;

	/**
	 * Constructor
	 */
	public IncludePropertyFilter() {
		includes = new ArrayList<String>();
	}

	/**
	 * @return the includes
	 */
	public List<String> getIncludes() {
		return includes;
	}

	/**
	 * @param includes the includes to set
	 */
	public void setIncludes(List<String> includes) {
		this.includes = includes;
	}

	/**
	 * @param source the owner of the property
	 * @param name the name of the property
	 * @param value the value of the property
	 * @return adapter type
	 */
	public boolean accept(Object source, String name, Object value) {
		if (includes != null) {
			if (includes.contains(name)) {
				return true;
			}
		}
		return false;
	}
}
