/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.bind;

import nuts.core.bind.filters.FilterPropertyFilter;
import nuts.core.bind.filters.PagerPropertyFilter;
import nuts.core.bind.filters.QueryPropertyFilter;
import nuts.core.bind.filters.SorterPropertyFilter;
import nuts.core.util.Filter;
import nuts.core.util.Pager;
import nuts.core.util.Query;
import nuts.core.util.Sorter;


public abstract class Binds {
	protected static void setDefaultSerializerOptions(AbstractSerializer as) {
		as.registerPropertyFilter(Filter.class, new FilterPropertyFilter(false));
		as.registerPropertyFilter(Pager.class, new PagerPropertyFilter(false));
		as.registerPropertyFilter(Query.class, new QueryPropertyFilter(false));
		as.registerPropertyFilter(Sorter.class, new SorterPropertyFilter(false));
	}	
}
