/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.bean.handlers;

import nuts.core.bean.Beans;
import nuts.core.lang.Types;

import java.lang.reflect.Type;
import java.util.List;

/**
 * ListBeanHandler
 */
public class ListBeanHandler<T extends List> extends AbstractArrayBeanHandler<T> {
	protected Type elementType;
	
	/**
	 * Constructor
	 * @param factory bean handler factory
	 * @param type bean type
	 */
	public ListBeanHandler(Beans factory, Type type) {
		super(factory, type);
		
		elementType = Types.getCollectionElementType(type);
	}
	
	@Override
	protected Type getElementType() {
		return elementType;
	}
	
	@Override
	protected int getSize(T list) {
		return list.size();
	}
	
	@Override
	protected Object getElement(T list, int index) {
		return list.get(index);
	}
	
	@Override
	@SuppressWarnings("unchecked")
	protected void setElement(T list, int index, Object value) {
		list.set(index, value);
	}
}
