/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.bean.handlers;

import nuts.core.bean.Beans;
import nuts.core.lang.Strings;
import nuts.core.lang.Types;

import java.lang.reflect.Type;
import java.util.Iterator;


/**
 */
public class IterableBeanHandler<T extends Iterable> extends ArrayBeanHandler<T> {
	protected Type elementType;
	
	/**
	 * Constructor
	 * @param factory bean handler factory
	 * @param type bean type
	 */
	public IterableBeanHandler(Beans factory, Type type) {
		super(factory, type);
		
		elementType = Types.getCollectionElementType(type);
	}
	
	/**
	 * get write property names
	 * @param array bean object (can be null)
	 * @return property names
	 */
	@Override
	public String[] getWritePropertyNames(T array) {
		return Strings.EMPTY_ARRAY;
	}

	@Override
	protected Type getElementType() {
		return elementType;
	}

	@Override
	protected int getSize(T list) {
		Iterator it = list.iterator();
		int n = 0;
		for ( ; it.hasNext(); it.next(), n++) {}
		return n;
	}
	
	@Override
	protected Object getElement(T list, int index) {
		Iterator it = list.iterator();
		int n = 0;
		for ( ; it.hasNext() && n < index; it.next(), n++) {}
		if (n != index || !it.hasNext()) {
			this.noSuchPropertyException(String.valueOf(index));
		}
		return it.next();
	}
	
	@Override
	protected void setElement(T list, int index, Object value) {
	}
}
