/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.bean.handlers;

import nuts.core.bean.Beans;
import nuts.core.lang.Types;

import java.lang.reflect.Array;
import java.lang.reflect.Type;

/**
 * ArrayBeanHandler
 */
public class ArrayBeanHandler<T> extends AbstractArrayBeanHandler<T> {
	/**
	 * Constructor
	 * @param factory bean handler factory
	 * @param type bean type
	 */
	public ArrayBeanHandler(Beans factory, Type type) {
		super(factory, type);

		if (!Types.isArrayType(type)) {
			throw new IllegalArgumentException(type + " is not a array type");
		}
	}

	@Override
	protected int getSize(T array) {
		return Array.getLength(array);
	}
	
	@Override
	protected Object getElement(T array, int index) {
		return Array.get(array, index);
	}
	
	@Override
	protected void setElement(T array, int index, Object value) {
		Array.set(array, index, value);
	}
}
