/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.bean;


/**
 * PropertyAccessor
 */
public class PropertyAccessor {
	private Object bean;

	private BeanHandler beanHandler;

	/**
	 * Constructor
	 * 
	 * @param bean bean object
	 */
	public PropertyAccessor(Object bean) {
		this.bean = bean;
		this.beanHandler = Beans.me().getBeanHandler(
			bean == null ? null : bean.getClass());
	}

	/**
	 * get property value
	 * 
	 * @param propertyName property name
	 * @return value
	 */
	@SuppressWarnings("unchecked")
	public Object get(String propertyName) {
		return beanHandler.getBeanValue(bean, propertyName);
	}

	/**
	 * set property value
	 * 
	 * @param propertyName property name
	 * @param value value
	 */
	@SuppressWarnings("unchecked")
	public void set(String propertyName, Object value) {
		beanHandler.setBeanValue(bean, propertyName, value);
	}
}
