<#--
/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
-->
<html>
<head>
	<title><@n.text name="title-page"/></title>
</head>

<body>

<div class="n-sect" id="a_login_input">
	<div class="n-sect-head">
		<h3 class="n-sect-title">
			<@n.text name="title-page"/>
			<#if forOrder!false>
				 - <@n.text name="text-order"/>
			</#if>
		</h3>
	</div>
	<div class="n-sect-body">

		<h4 class="caption"><@n.text name="text-unregistered"/></h4>
		<br/>
		<div class="indent2">
			<@n.url var='_ri' action='register_input'>
				<@s.param name='redirect' value='redirect'/>
			</@n.url>
			<@n.a icon="n-icon-vcard_add" href="${_ri}"><@n.text name="link-register"/></@n.a>
		</div>
		
		<br/><br/>
		<div class="hr"></div>

		<h4 class="caption"><@n.text name="text-registered"/></h4>
		<br/>

		<div class="indent2">
			<h4><@n.text name="text-input"/></h4>
	
			<#include "/nuts/exts/struts2/views/action-prompt.ftl"/>
	
			<@n.form id="loginForm" action="login_login" method="post" 
				cssClass="n-eform" theme="nxhtml" loadmask="false"
				onsubmit="return onLoginSubmit();">
				<@n.hidden name="redirect"/>
				<@n.textfield key="username" size="30" maxlength="80" required="true"/>
				<@n.password key="password" size="30" maxlength="16" required="true"/>
				<@n.checkbox name="save" clabel="${action.getText('save')}" fieldValue="on"/>
				<@n.submit icon="n-icon-bullet_key" sicon="n-icon-bullet_go"><@n.text name="button-login"/></@n.submit>
			</@n.form>
			
			<br/>
			<h6><@n.text name="text-password-forgot"/></h6>
			<div class="indent2">
				<@n.a icon="n-icon-arrow_turn_left" action="passwordreturn_input"><@n.text name="link-password-return"/></@n.a>
			</div>
		</div>
		
		<br/><br/>
	</div>
</div>

<script type="text/javascript">
	function getFormValues() {
		var fvs = {};
	
		fvs.u = $("#loginForm_username").val();
		fvs.p = $("#loginForm_password").val();
		fvs.s = $("#loginForm_save").attr('checked');
	
		return fvs;
	}
	
	function setFormValues(fvs) {
		$("#loginForm_username").val(fvs.u);
		$("#loginForm_password").val(fvs.p);
		$("#loginForm_save").attr('checked', fvs.s);
	}
	
	function loadLoginInfo() {
		var li = $.jcookie('UTICKET');
		return li;
	}
	
	function saveLoginInfo(fvs) {
		var conf = {
			path: '${base}/'
		};
		
		var cvs = {};
	
		if (fvs.s) {
			cvs.s = true;
			cvs.u = fvs.u.strip();
			cvs.p = fvs.p.strip();
			$.jcookie('UTICKET', cvs, conf);
		}
	}
	
	function onLoginSubmit() {
		$("#loginForm").loadmask('<@n.text name="button-login"/>...');
		saveLoginInfo(getFormValues());
	}

<#if !action.hasErrors()>
	$(function() {
		var li = loadLoginInfo();
		setFormValues(li);
	});
</#if>
</script>

</body>
</html>
