<#--
/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
-->
<div id="header">
	<div id="header_adsbar">
		<a id="site_logo" href="${base}/">
			<span id="site_name"><@n.text name="site-name"/></span><br/>
			<span id="site_desc"><@n.text name="site-desc"> </@n.text></span>
		</a>
	</div>
	<div id="header_navbar">
		<div id="site_toplinks">
		<#if utils.loginUser??>
			<@n.a icon="n-icon-user_gold" href="${base}/user/">${utils.loginUser.name}</@n.a> | 
		</#if>
			<@n.a id="site_theme" sicon="ui-icon-carat-1-s" href="#"><@n.text name="navi-theme"><@s.param>${uiTheme}</@s.param></@n.text></@n.a>
			 | 
			<@n.a id="site_mlang" sicon="ui-icon-carat-1-s" href="#"><@n.text name="navi-language"/></@n.a>
			 | 
			<@n.a icon="n-icon-house" href="${base}/"><@n.text name="navi-home"/></@n.a>
			 | 
		<#if utils.loginUser??>
			<@n.a icon="n-icon-lock_go" action="login_logout" namespace="/user"><@n.text name='navi-user-logout'/></@n.a>
		<#else>
			<@n.a icon="n-icon-bullet_key" href="${base}/user/"><@n.text name="navi-user-login"/></@n.a>
		</#if>
		</div>
	</div>
	<script type="text/javascript">
		$(function() {
			$.popup({
				id: "popup_site_theme",
				url: "<@n.url action='themes' namespace='/'/>",
				params: { '__popup': 'true'}
			});
			$.popup({
				id: "popup_site_mlang",
				url: "<@n.url action='languages' namespace='/'/>",
				params: { '__popup': 'true'}
			});
	
			$('#site_theme').popup({
				id: 'popup_site_theme',
				callback: function(v) {
					s_setTheme(v); 
				}
			});				
			$('#site_mlang').popup({
				id: 'popup_site_mlang',
				callback: function(v) {
					s_setLang(v);
				}
			});				
		});
	</script>
</div>
