/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.aws.dao;

import nuts.core.castor.Castors;
import nuts.core.dao.AbstractDataAccessClient;
import nuts.core.dao.DaoSession;

import java.util.Properties;

import com.amazonaws.services.simpledb.AmazonSimpleDB;

/**
 */
public class AwsDataAccessClient extends AbstractDataAccessClient implements AwsSimpleDBAware {
	
	private Castors castors = Castors.me();
	
	private AmazonSimpleDB amazonSimpleDB;
	
	/**
	 */
	public AwsDataAccessClient() {
		super();
	}

	/**
	 * @param amazonSimpleDB the amazonSimpleDB to set
	 */
	public AwsDataAccessClient(AmazonSimpleDB amazonSimpleDB, Properties props) {
		super(props);
		this.amazonSimpleDB = amazonSimpleDB;
	}

	public Castors getCastors() {
		return castors;
	}

	public void setCastors(Castors castors) {
		this.castors = castors;
	}

	/**
	 * @return the amazonSimpleDB
	 */
	public AmazonSimpleDB getAmazonSimpleDB() {
		return amazonSimpleDB;
	}

	/**
	 * @param amazonSimpleDB the amazonSimpleDB to set
	 */
	public void setAmazonSimpleDB(AmazonSimpleDB amazonSimpleDB) {
		this.amazonSimpleDB = amazonSimpleDB;
	}

	/**
	 * open session
	 * @return DataAccessSession
	 */
	public DaoSession openSession(boolean autoCommit) {
		return new AwsDataAccessSession(this, amazonSimpleDB, autoCommit);
	}

}
