/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.aems.action.tools;

import nuts.core.lang.Strings;
import nuts.exts.struts2.actions.CommonAction;
import nuts.exts.xwork2.util.ContextUtils;

import com.opensymphony.xwork2.util.ValueStack;

/**
 */
public class OgnlEvaluateAction extends CommonAction {

	private String expr;
	private Object value;

	/**
	 * @return the expr
	 */
	public String getExpr() {
		return expr;
	}

	/**
	 * @param expr the expr to set
	 */
	public void setExpr(String expr) {
		this.expr = expr;
	}

	/**
	 * @return the value
	 */
	public Object getValue() {
		return value;
	}

	/**
	 * @param value the value to set
	 */
	public void setValue(Object value) {
		this.value = value;
	}

	/**
	 * execute
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String execute() throws Exception {
		if (Strings.isNotBlank(expr)) {
			ValueStack vs = ContextUtils.getValueStack();
			value = vs.findValue(expr);
			return SUCCESS;
		}
		else {
			return INPUT;
		}
	}
}
