/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.aems.action.resource;

import nuts.aems.constant.AC;
import nuts.aems.constant.GC;
import nuts.aems.constant.RC;
import nuts.aems.model.bean.Resource;
import nuts.core.lang.Strings;
import nuts.core.lang.i18n.Locales;

import java.util.List;
import java.util.Locale;


/**
 * ResourceExAction
 */
public class ResourceExAction extends ResourceAction {

	/**
	 * Constructor
	 */
	public ResourceExAction() {
		super();
	}

	/**
	 * isValidLocale
	 * @param language lanaguage
	 * @param country country
	 * @return true - if locale is valid
	 */
	public boolean isValidLocale(String language, String country) {
		if (Strings.isNotEmpty(language) && Strings.isNotEmpty(country)) {
			if (!GC.LOCALE_ALL.equals(country)) {
				return Locales.isAvailableLocale(new Locale(language, country));
			}
		}
		return true;
	}
	
	private void addReloadMessage() {
		addApplicationMessage(AC.RESOURCE_RELOAD, 
			getText(RC.MESSAGE_RESOURCE_RELOAD));
	}

	/**
	 * commitInsert
	 * @param data data
	 */
	@Override
	protected void commitInsert(Resource data) throws Exception {
		super.commitInsert(data);
		
//		if (!Application.getDatabaseResourceLoader().putResource(data.getClazz(),
//			data.getLanguage(), data.getCountry(), null, data.getName(), data.getValue())) {
//			addReloadMessage();
//		}
		addReloadMessage();
	}

	/**
	 * commitUpdate
	 * @param data data
	 * @param srcData source data
	 */
	@Override
	protected void commitUpdate(Resource data, Resource srcData) throws Exception {
		super.commitUpdate(data, srcData);
		
//		if (!Application.getDatabaseResourceLoader().putResource(data.getClazz(),
//			data.getLanguage(), data.getCountry(), null, data.getName(), data.getValue())) {
//			addReloadMessage();
//		}
		addReloadMessage();
	}

	/**
	 * commitDelete
	 * @param data data
	 */
	@Override
	protected void commitDelete(Resource data) throws Exception {
		super.commitDelete(data);

//		if (!Application.getDatabaseResourceLoader().putResource(data.getClazz(),
//			data.getLanguage(), data.getCountry(), null, data.getName(), null)) {
//			addReloadMessage();
//		}
		addReloadMessage();
	}

	/**
	 * commitBulkDelete
	 * @param dataList data list
	 * @throws Exception if an error occurs
	 */
	@Override
	protected void commitBulkDelete(List<Resource> dataList) throws Exception {
		super.commitBulkDelete(dataList);
		
//		for (Resource data : dataList) {
//			if (!Application.getDatabaseResourceLoader().putResource(data.getClazz(),
//				data.getLanguage(), data.getCountry(), null, data.getName(), data.getValue())) {
//				addReloadMessage();
//				break;
//			}
//		}
		addReloadMessage();
	}
}