/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.aems.action.user;

import nuts.aems.action.AbstractAction;
import nuts.aems.constant.GC;
import nuts.aems.constant.RC;
import nuts.aems.constant.TPL;
import nuts.aems.model.bean.User;
import nuts.aems.model.dao.UserDAO;
import nuts.aems.model.example.UserExample;
import nuts.core.lang.Strings;
import nuts.core.servlet.HttpServletUtils;
import nuts.exts.struts2.util.StrutsContextUtils;

import java.util.Calendar;
import java.util.List;

import org.apache.commons.mail.EmailException;


/**
 * RegisterAction
 */
public class RegisterAction extends AbstractAction {

	protected User user;

	protected String confirmEmail;

	protected String confirmPassword;

	private String redirect;

	/**
	 * Constructor
	 */
	public RegisterAction() {
		user = new User();
	}
	
	/**
	 * @return the redirect
	 */
	public String getRedirect() {
		return redirect;
	}

	/**
	 * @param redirect the redirect to set
	 */
	public void setRedirect(String redirect) {
		this.redirect = redirect;
	}

	/**
	 * @return the confirmEmail
	 */
	public String getConfirmEmail() {
		return confirmEmail;
	}

	/**
	 * @param confirmEmail the confirmEmail to set
	 */
	public void setConfirmEmail(String confirmEmail) {
		this.confirmEmail = confirmEmail;
	}

	/**
	 * @return the confirmPassword
	 */
	public String getConfirmPassword() {
		return confirmPassword;
	}

	/**
	 * @param confirmPassword the confirmPassword to set
	 */
	public void setConfirmPassword(String confirmPassword) {
		this.confirmPassword = confirmPassword;
	}

	/**
	 * @return the model
	 */
	public User getD() {
		return user;
	}

	/**
	 * @param user the user to set
	 */
	public void setD(User user) {
		this.user = user;
	}

	/**
	 * check email
	 * @return true/false
	 * @throws Exception
	 */
	protected boolean checkEmail() throws Exception {
		UserDAO dao = new UserDAO(getDaoSession());

		UserExample example = new UserExample();
		example.email().equalTo(user.getEmail());

		List<User> list = dao.selectList(example);

		if (list.size() > 0) {
			addFieldError("da.email", getText("error-email-is-used"));
			return false;
		}
		else {
			return true;
		}
	}

	/**
	 * confirm
	 * @return result name
	 * @throws Exception if an error occurs
	 */
	public String confirm() throws Exception {
		if (!checkEmail()) {
			return INPUT;
		}

		addActionConfirm(getText("message-confirm"));

		return CONFIRM;
	}

	/**
	 * insert
	 * @return result name
	 * @throws Exception if an error occurs
	 */
	public String insert() throws Exception {
		if (!checkEmail()) {
			return INPUT;
		}

		UserDAO dao = new UserDAO(getDaoSession());

		user.setId(null);
		user.setGroupLevel(GC.GUEST_LEVEL);
		user.setGroupId(GC.GUESTS_ID);
		user.setInvalid(false);
		user.setCusid(GC.UNKNOWN_USID);
		user.setCtime(Calendar.getInstance().getTime());
		user.setUusid(user.getCusid());
		user.setUtime(Calendar.getInstance().getTime());
		dao.insert(user);

		try {
			utils().sendTemplateMail(user, TPL.MAIL_REGISTER, user);
		}
		catch (EmailException e) {
			String msg = getText(RC.ERROR_SENDMAIL, new String[] { user.getEmail() });
			if (utils().ignoreEmailException()) {
				addActionWarning(msg);
			}
			else {
				addActionError(msg);
				getDaoSession().rollback();
				return INPUT;
			}
		}

		getDaoSession().commit();

		utils().setUserGroupInfo(user, getDaoSession());
		utils().setLoginUser(user);

		if (Strings.isNotEmpty(redirect)) {
			int timeout = getTextAsInt(RC.REDIRECT_TIMEOUT, 0);
			if (timeout < 1) {
				HttpServletUtils.sendRedirect(StrutsContextUtils.getServletResponse(), redirect);
				return NONE;
			}
		}

		addActionMessage(getText(RC.MESSAGE_SUCCESS));
		return SUCCESS;
	}
}
