/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.aems.action.user;

import nuts.aems.WebApplet;
import nuts.aems.action.AbstractAction;
import nuts.aems.model.bean.User;
import nuts.aems.model.dao.UserDAO;
import nuts.aems.model.example.UserExample;
import nuts.core.dao.DaoException;
import nuts.core.lang.Strings;


/**
 * LoginAction
 */
public class LoginAction extends AbstractAction {
	private String username;
	private String password;
	private Boolean autosave;
	private String redirect;


	/**
	 * @return the username
	 */
	public String getUsername() {
		return username;
	}

	/**
	 * @param username the username to set
	 */
	public void setUsername(String username) {
		this.username = Strings.stripToEmpty(username);
	}

	/**
	 * @return the password
	 */
	public String getPassword() {
		return password;
	}

	/**
	 * @param password the password to set
	 */
	public void setPassword(String password) {
		this.password = Strings.stripToEmpty(password);
	}


	/**
	 * @return the autosave
	 */
	public Boolean getAutosave() {
		return autosave;
	}

	/**
	 * @param autosave the autosave to set
	 */
	public void setAutosave(Boolean autosave) {
		this.autosave = autosave;
	}

	/**
	 * @return the redirect
	 */
	public String getRedirect() {
		return redirect;
	}

	/**
	 * @param redirect the redirect to set
	 */
	public void setRedirect(String redirect) {
		this.redirect = redirect;
	}

	private User getAdminUser() {
		User user = null;
		if (WebApplet.get().isAdminUser(username, password)) {
			user = WebApplet.get().createAdminUser();
		}
		return user;
	}

	/**
	 * input
	 * @return result name
	 * @throws Exception if an error occurs
	 */
	public String input() throws Exception {
		if (username == null) {
			User u = utils().getLoginUser();
			if (u != null) {
				username = u.getEmail();
			}
		}
		return INPUT;
	}
	
	/**
	 * login
	 * @return result name
	 * @throws Exception if an error occurs
	 */
	public String login() throws Exception {
		User user = null;
		try {
			UserDAO udao = new UserDAO(getDaoSession());

			UserExample uexp = udao.createExample();

			uexp.invalid().isFalse()
				.and().email().equalTo(username);

			user = udao.selectOne(uexp);

			if (user != null) {
				if (user.getPassword().equals(password)) {
					if (Strings.isEmpty(user.getGroupName())
							|| user.getGroupPermits() == null) {
						utils().setUserGroupInfo(user, getDaoSession());
					}
				}
				else {
					user = null;
				}
			}
			else {
				user = getAdminUser();
			}
		}
		catch (DaoException e) {
			log.warn("LOGIN ERROR", e);
			user = getAdminUser();
		}

		if (user != null) {
			user.setAutoLogin(autosave);
			utils().setLoginUser(user);

			addActionMessage(getText("message-login-success"));
			return SUCCESS;
		}
		else {
			addActionError(getText("error-login"));
			return INPUT;
		}
	}

	/**
	 * logout
	 * @return result name
	 * @throws Exception if an error occurs
	 */
	public String logout() throws Exception {
		utils().removeLoginUser();
		addActionMessage(getText("message-logout-success"));
		return "logout";
	}

}