/*
 * This file is part of Nuts Framework.
 * Copyright (C) 2009 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.aems.action.ndfsfile;

import nuts.exts.struts2.actions.ModelDrivenAction;
import nuts.exts.vfs.ndfs.dao.NdfsDataDAO;
import nuts.exts.vfs.ndfs.dao.NdfsDataExample;
import nuts.exts.vfs.ndfs.dao.NdfsFile;
import nuts.exts.vfs.ndfs.dao.NdfsFileExample;

import java.util.ArrayList;
import java.util.List;

/**
 */
public class NdfsFileAction extends ModelDrivenAction<NdfsFile, NdfsFileExample> {
	private String ndfsDataModelName;
	private NdfsDataDAO ndfsDataDAO;

	/**
	 * Constructor
	 */
	public NdfsFileAction() {
	}

	/**
	 * @return the NdfsFile
	 */
	public NdfsFile getD() {
		return super.getData();
	}

	/**
	 * @param ndfsFile the ndfsFile to set
	 */
	public void setD(NdfsFile ndfsFile) {
		super.setData(ndfsFile);
	}

	/**
	 * @return the NdfsFile list
	 */
	public List<NdfsFile> getDs() {
		return super.getDataList();
	}

	/**
	 * @param ndfsFileList the ndfsFileList to set
	 */
	public void setDs(List<NdfsFile> ndfsFileList) {
		super.setDataList(ndfsFileList);
	}

	/**
	 * @return the ndfsDataModelName
	 */
	public String getNdfsDataModelName() {
		return ndfsDataModelName;
	}

	/**
	 * @param ndfsDataModelName the ndfsDataModelName to set
	 */
	public void setNdfsDataModelName(String ndfsDataModelName) {
		this.ndfsDataModelName = ndfsDataModelName;
	}

	/**
	 * @return the ndfsDataDAO
	 */
	protected NdfsDataDAO getNdfsDataDAO() {
		if (ndfsDataDAO == null) {
			ndfsDataDAO = createNdfsDataDAO();
		}
		return ndfsDataDAO;
	}

	protected NdfsDataDAO createNdfsDataDAO() {
		return (NdfsDataDAO)getDaoSession().getModelDAO(ndfsDataModelName);
	}
	
	/**
	 * @param ndfsDataDAO the ndfsDataDAO to set
	 */
	protected void setNdfsDataDAO(NdfsDataDAO ndfsDataDAO) {
		this.ndfsDataDAO = ndfsDataDAO;
	}

	/**
	 * prepareDefaultData
	 * @param data data
	 * @return data
	 */
	protected NdfsFile prepareDefaultData(NdfsFile data) throws Exception {
		if (data == null) {
			data = new NdfsFile();
		}
		return data;
	}

	/**
	 * list
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String list() throws Exception {
		if (get_save() == null) {
			set_save(true);
		}
		return doList();
	}
	
	/**
	 * list_csv
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String list_csv() throws Exception {
		if (get_load() == null) {
			set_load(false);
		}
		if (get_save() == null) {
			set_save(false);
		}
		return doList();
	}
	
	/**
	 * list_print
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String list_print() throws Exception {
		if (get_load() == null) {
			set_load(false);
		}
		if (get_save() == null) {
			set_save(false);
		}
		return doList();
	}
	
	/**
	 * list_popup
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String list_popup() throws Exception {
		addLimitToPager();
		if (get_save() == null) {
			set_save(true);
		}
		return doList();
	}
	
	/**
	 * bdelete
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String bdelete() throws Exception {
		return doBulkDeleteSelect();
	}

	/**
	 * bdelete_execute
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String bdelete_execute() throws Exception {
		return doBulkDeleteExecute();
	}

	/**
	 * view
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String view() throws Exception {
		return doViewSelect();
	}
	
	/**
	 * view_input
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String view_input() throws Exception {
		return doViewInput();
	}

	/**
	 * print
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String print() throws Exception {
		return doViewSelect();
	}

	/**
	 * print_input
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String print_input() throws Exception {
		return doViewInput();
	}

	/**
	 * copy
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String copy() throws Exception {
		return doInsertSelect();
	}

	/**
	 * copy_input
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String copy_input() throws Exception {
		return doInsertInput();
	}

	/**
	 * copy_confirm
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String copy_confirm() throws Exception {
		return doInsertConfirm();
	}

	/**
	 * copy_execute
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String copy_execute() throws Exception {
		return doInsertExecute();
	}

	/**
	 * insert
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String insert() throws Exception {
		return doInsertClear();
	}

	/**
	 * insert_input
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String insert_input() throws Exception {
		return doInsertInput();
	}

	/**
	 * insert_confirm
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String insert_confirm() throws Exception {
		return doInsertConfirm();
	}

	/**
	 * insert_execute
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String insert_execute() throws Exception {
		return doInsertExecute();
	}

	/**
	 * update
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String update() throws Exception {
		return doUpdateSelect();
	}

	/**
	 * update_input
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String update_input() throws Exception {
		return doUpdateInput();
	}

	/**
	 * update_confirm
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String update_confirm() throws Exception {
		return doUpdateConfirm();
	}

	/**
	 * update_execute
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String update_execute() throws Exception {
		return doUpdateExecute();
	}

	/**
	 * delete
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String delete() throws Exception {
		return doDeleteSelect();
	}

	/**
	 * delete_execute
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String delete_execute() throws Exception {
		return doDeleteExecute();
	}

	/**
	 * startDelete
	 * @param data data
	 */
	@SuppressWarnings("unchecked")
	@Override
	protected void startDelete(NdfsFile data) throws Exception {
		super.startDelete(data);

		NdfsDataExample dexp = getNdfsDataDAO().createExample();
		dexp.fileId().equalTo(data.getId());
		getNdfsDataDAO().deleteByExample(dexp);
	}

	/**
	 * startBulkDelete
	 * @param dataList dataList
	 */
	@SuppressWarnings("unchecked")
	@Override
	protected void startBulkDelete(List<NdfsFile> dataList) throws Exception {
		super.startBulkDelete(dataList);
		
		NdfsDataExample dexp = getNdfsDataDAO().createExample();
		List<Long> ids = new ArrayList<Long>(dataList.size());
		for (NdfsFile f : dataList) {
			ids.add(f.getId());
		}
		dexp.fileId().in(ids);
		getNdfsDataDAO().deleteByExample(dexp);
	}
}
