/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.aems.action;

import nuts.aems.WebApplet;
import nuts.aems.util.BaseActionConsts;
import nuts.aems.util.BaseActionUtils;
import nuts.exts.struts2.actions.CommonDaoAction;

import java.util.Map;

/**
 */
public abstract class AbstractAction extends CommonDaoAction {

	/**
	 * Constructor
	 */
	public AbstractAction() {
	}

	/**
	 * @return the cache
	 */
	@SuppressWarnings("unchecked")
	public Map getCache() {
		return WebApplet.get().getCache();
	}

	/**
	 * @return the utils
	 */
	protected BaseActionUtils utils() {
		return (BaseActionUtils)super.getUtils();
	}

	/**
	 * @return the consts
	 */
	protected BaseActionConsts consts() {
		return (BaseActionConsts)super.getConsts();
	}

	/**
	 * hasPermission
	 * @param namespace namespace
	 * @param action action
	 * @return true if action has access permit
	 */
	@Override
	public boolean hasPermission(String namespace, String action) {
		return utils().hasPermission(namespace, action);
	}
}
