/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.mapping.statement;

import com.ibatis.sqlmap.client.event.RowHandler;
import com.ibatis.sqlmap.engine.mapping.result.ResultMap;
import com.ibatis.sqlmap.engine.scope.StatementScope;
import com.ibatis.sqlmap.engine.type.XmlTypeMarker;
import java.io.StringWriter;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;

public class RowHandlerCallback {
    private RowHandler rowHandler;
    private ResultMap resultMap;
    private Object resultObject;

    public RowHandlerCallback(ResultMap resultMap, Object resultObject, RowHandler rowHandler) {
        this.rowHandler = rowHandler;
        this.resultMap = resultMap;
        this.resultObject = resultObject;
    }

    public void handleResultObject(StatementScope statementScope, Object[] results, ResultSet rs) throws SQLException {
        statementScope.setCurrentNestedKey(null);
        Object object = this.resultMap.resolveSubMap(statementScope, rs).setResultObjectValues(statementScope, this.resultObject, results);
        if (object != ResultMap.NO_VALUE) {
            Class targetType;
            int stackDepth = statementScope.getSession().getRequestStackDepth();
            if (stackDepth == 1 && XmlTypeMarker.class.isAssignableFrom(targetType = statementScope.getResultMap().getResultClass()) && object instanceof Document) {
                object = this.documentToString((Document)object);
            }
            this.rowHandler.handleRow(object);
        }
    }

    private String documentToString(Document document) {
        String s = null;
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            DOMSource source = new DOMSource(document);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            transformer.transform(source, result);
            s = writer.getBuffer().toString();
        }
        catch (TransformerException e) {
            throw new RuntimeException("Error occurred.  Cause: " + e, e);
        }
        return s;
    }

    public RowHandler getRowHandler() {
        return this.rowHandler;
    }
}

