/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter.javahl;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.tigris.subversion.javahl.BlameCallback2;
import org.tigris.subversion.javahl.ClientException;
import org.tigris.subversion.javahl.ConflictResolverCallback;
import org.tigris.subversion.javahl.CopySource;
import org.tigris.subversion.javahl.Depth;
import org.tigris.subversion.javahl.DiffSummaryReceiver;
import org.tigris.subversion.javahl.DirEntry;
import org.tigris.subversion.javahl.Info;
import org.tigris.subversion.javahl.Info2;
import org.tigris.subversion.javahl.ListCallback;
import org.tigris.subversion.javahl.Lock;
import org.tigris.subversion.javahl.LogMessageCallback;
import org.tigris.subversion.javahl.Mergeinfo;
import org.tigris.subversion.javahl.PromptUserPassword;
import org.tigris.subversion.javahl.PropertyData;
import org.tigris.subversion.javahl.Revision;
import org.tigris.subversion.javahl.RevisionRange;
import org.tigris.subversion.javahl.SVNClientInterface;
import org.tigris.subversion.javahl.Status;
import org.tigris.subversion.javahl.StatusCallback;
import org.tigris.subversion.javahl.SubversionException;
import org.tigris.subversion.svnclientadapter.AbstractClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNAnnotations;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNConflictResolver;
import org.tigris.subversion.svnclientadapter.ISVNDirEntry;
import org.tigris.subversion.svnclientadapter.ISVNDirEntryWithLock;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.ISVNLogMessage;
import org.tigris.subversion.svnclientadapter.ISVNLogMessageCallback;
import org.tigris.subversion.svnclientadapter.ISVNMergeInfo;
import org.tigris.subversion.svnclientadapter.ISVNNotifyListener;
import org.tigris.subversion.svnclientadapter.ISVNProgressListener;
import org.tigris.subversion.svnclientadapter.ISVNPromptUserPassword;
import org.tigris.subversion.svnclientadapter.ISVNProperty;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNBaseDir;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNDiffSummary;
import org.tigris.subversion.svnclientadapter.SVNInfoUnversioned;
import org.tigris.subversion.svnclientadapter.SVNLogMessageCallback;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNNotificationHandler;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNRevisionRange;
import org.tigris.subversion.svnclientadapter.SVNScheduleKind;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;
import org.tigris.subversion.svnclientadapter.SVNStatusUnversioned;
import org.tigris.subversion.svnclientadapter.SVNUrl;
import org.tigris.subversion.svnclientadapter.javahl.JhlAnnotations;
import org.tigris.subversion.svnclientadapter.javahl.JhlConflictResolver;
import org.tigris.subversion.svnclientadapter.javahl.JhlConverter;
import org.tigris.subversion.svnclientadapter.javahl.JhlDiffSummaryReceiver;
import org.tigris.subversion.svnclientadapter.javahl.JhlDirEntryWithLock;
import org.tigris.subversion.svnclientadapter.javahl.JhlInfo;
import org.tigris.subversion.svnclientadapter.javahl.JhlInfo2;
import org.tigris.subversion.svnclientadapter.javahl.JhlLogMessageCallback;
import org.tigris.subversion.svnclientadapter.javahl.JhlMergeInfo;
import org.tigris.subversion.svnclientadapter.javahl.JhlNotificationHandler;
import org.tigris.subversion.svnclientadapter.javahl.JhlProgressListener;
import org.tigris.subversion.svnclientadapter.javahl.JhlPromptUserPassword;
import org.tigris.subversion.svnclientadapter.javahl.JhlPropertyData;
import org.tigris.subversion.svnclientadapter.javahl.JhlStatus;
import org.tigris.subversion.svnclientadapter.javahl.SVNUrlWithPegRevision;
import org.tigris.subversion.svnclientadapter.utils.Messages;

public abstract class AbstractJhlClientAdapter
extends AbstractClientAdapter {
    protected SVNClientInterface svnClient;
    protected JhlNotificationHandler notificationHandler;
    protected JhlConflictResolver conflictResolver;
    protected JhlProgressListener progressListener;

    public SVNClientInterface getSVNClient() {
        return this.svnClient;
    }

    public void addNotifyListener(ISVNNotifyListener listener) {
        this.notificationHandler.add(listener);
    }

    public void removeNotifyListener(ISVNNotifyListener listener) {
        this.notificationHandler.remove(listener);
    }

    public SVNNotificationHandler getNotificationHandler() {
        return this.notificationHandler;
    }

    public void setUsername(String username) {
        this.svnClient.username(username);
    }

    public void setPassword(String password) {
        this.notificationHandler.setCommand(0);
        this.svnClient.password(password);
    }

    public void setPromptUserPassword(PromptUserPassword prompt) {
        this.svnClient.setPrompt(prompt);
    }

    protected static String fileToSVNPath(File file, boolean canonical) {
        if (file == null) {
            return null;
        }
        if (canonical) {
            try {
                return file.getCanonicalPath().replace('\\', '/');
            }
            catch (IOException e) {
                return null;
            }
        }
        return file.getPath().replace('\\', '/');
    }

    public void addFile(File file) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(1);
            this.notificationHandler.logCommandLine("add -N " + file.toString());
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(file));
            this.svnClient.add(AbstractJhlClientAdapter.fileToSVNPath(file, false), false);
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public void addDirectory(File file, boolean recurse) throws SVNClientException {
        this.addDirectory(file, recurse, false);
    }

    public void addDirectory(File dir, boolean recurse, boolean force) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(1);
            this.notificationHandler.logCommandLine("add" + (recurse ? "" : " -N") + (force ? " --force" : "") + " " + dir.toString());
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(dir));
            this.svnClient.add(AbstractJhlClientAdapter.fileToSVNPath(dir, false), recurse, force);
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public void checkout(SVNUrl moduleName, File destPath, SVNRevision revision, boolean recurse) throws SVNClientException {
        this.checkout(moduleName, destPath, revision, Depth.infinityOrImmediates((boolean)recurse), false, true);
    }

    public void checkout(SVNUrl moduleName, File destPath, SVNRevision revision, int depth, boolean ignoreExternals, boolean force) throws SVNClientException {
        try {
            String url = moduleName.toString();
            this.notificationHandler.setCommand(2);
            StringBuffer commandLine = new StringBuffer("checkout " + url + " -r " + revision.toString() + this.depthCommandLine(depth));
            if (ignoreExternals) {
                commandLine.append(" --ignore-externals");
            }
            if (force) {
                commandLine.append(" --force");
            }
            this.notificationHandler.logCommandLine(commandLine.toString());
            this.notificationHandler.setBaseDir(new File("."));
            this.svnClient.checkout(url, AbstractJhlClientAdapter.fileToSVNPath(destPath, false), JhlConverter.convert(revision), JhlConverter.convert(revision), depth, ignoreExternals, force);
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public long commit(File[] paths, String message, boolean recurse) throws SVNClientException {
        return this.commit(paths, message, recurse, false);
    }

    public long commit(File[] paths, String message, boolean recurse, boolean keepLocks) throws SVNClientException {
        try {
            String fixedMessage = this.fixSVNString(message);
            if (fixedMessage == null) {
                fixedMessage = "";
            }
            this.notificationHandler.setCommand(3);
            String[] files = new String[paths.length];
            String commandLine = "commit -m \"" + this.getFirstMessageLine(fixedMessage) + "\"";
            if (!recurse) {
                commandLine = commandLine + " -N";
            }
            if (keepLocks) {
                commandLine = commandLine + " --no-unlock";
            }
            for (int i = 0; i < paths.length; ++i) {
                files[i] = AbstractJhlClientAdapter.fileToSVNPath(paths[i], false);
            }
            commandLine = this.appendPaths(commandLine, files);
            this.notificationHandler.logCommandLine(commandLine);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(paths));
            long newRev = this.svnClient.commit(files, fixedMessage, recurse, keepLocks);
            if (newRev > 0L) {
                this.notificationHandler.logCompleted("Committed revision " + newRev + ".");
            }
            return newRev;
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public ISVNDirEntry[] getList(SVNUrl url, SVNRevision revision, boolean recurse) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(11);
            String commandLine = "list -r " + revision.toString() + (recurse ? "-R" : "") + " " + url.toString();
            this.notificationHandler.logCommandLine(commandLine);
            this.notificationHandler.setBaseDir(new File("."));
            return JhlConverter.convert(this.svnClient.list(url.toString(), JhlConverter.convert(revision), recurse));
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public ISVNDirEntry[] getList(SVNUrl url, SVNRevision revision, SVNRevision pegRevision, boolean recurse) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(11);
            String commandLine = "list -r " + revision.toString() + (recurse ? "-R" : "") + " " + url.toString();
            this.notificationHandler.logCommandLine(commandLine);
            this.notificationHandler.setBaseDir(new File("."));
            return JhlConverter.convert(this.svnClient.list(url.toString(), JhlConverter.convert(revision), JhlConverter.convert(pegRevision), recurse));
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public ISVNDirEntry[] getList(File path, SVNRevision revision, boolean recurse) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(11);
            String target = AbstractJhlClientAdapter.fileToSVNPath(path, false);
            String commandLine = "list -r " + revision.toString() + (recurse ? "-R" : "") + " " + path;
            this.notificationHandler.logCommandLine(commandLine);
            this.notificationHandler.setBaseDir(new File("."));
            return JhlConverter.convert(this.svnClient.list(target, JhlConverter.convert(revision), recurse));
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public ISVNDirEntry[] getList(File path, SVNRevision revision, SVNRevision pegRevision, boolean recurse) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(11);
            String target = AbstractJhlClientAdapter.fileToSVNPath(path, false);
            String commandLine = "list -r " + revision.toString() + (recurse ? "-R" : "") + " " + path;
            this.notificationHandler.logCommandLine(commandLine);
            this.notificationHandler.setBaseDir(new File("."));
            return JhlConverter.convert(this.svnClient.list(target, JhlConverter.convert(revision), JhlConverter.convert(pegRevision), recurse));
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public ISVNDirEntryWithLock[] getListWithLocks(SVNUrl url, SVNRevision revision, SVNRevision pegRevision, boolean recurse) throws SVNClientException {
        final ArrayList dirEntryList = new ArrayList();
        ListCallback callback = new ListCallback(){

            public void doEntry(DirEntry dirent, Lock lock) {
                if (dirent.getPath().length() == 0) {
                    if (dirent.getNodeKind() == 1) {
                        String absPath = dirent.getAbsPath();
                        int lastSeparator = absPath.lastIndexOf(47);
                        String path = absPath.substring(lastSeparator, absPath.length());
                        dirent.setPath(path);
                    } else {
                        return;
                    }
                }
                dirEntryList.add(new JhlDirEntryWithLock(dirent, lock));
            }
        };
        try {
            this.notificationHandler.setCommand(11);
            String commandLine = "list -r " + revision.toString() + (recurse ? "-R" : "") + " " + url.toString();
            this.notificationHandler.logCommandLine(commandLine);
            this.notificationHandler.setBaseDir(new File("."));
            this.svnClient.list(url.toString(), JhlConverter.convert(revision), JhlConverter.convert(pegRevision), Depth.infinityOrImmediates((boolean)recurse), -1, true, callback);
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
        ISVNDirEntryWithLock[] dirEntries = new ISVNDirEntryWithLock[dirEntryList.size()];
        dirEntryList.toArray(dirEntries);
        return dirEntries;
    }

    public ISVNDirEntry getDirEntry(SVNUrl url, SVNRevision revision) throws SVNClientException {
        ISVNDirEntry[] entries = this.getList(url.getParent(), revision, false);
        String expectedPath = url.getLastPathSegment();
        for (int i = 0; i < entries.length; ++i) {
            if (!entries[i].getPath().equals(expectedPath)) continue;
            return entries[i];
        }
        return null;
    }

    public ISVNDirEntry getDirEntry(File path, SVNRevision revision) throws SVNClientException {
        ISVNDirEntry[] entries = this.getList(path.getParentFile(), revision, false);
        String expectedPath = path.getName();
        for (int i = 0; i < entries.length; ++i) {
            if (!entries[i].getPath().equals(expectedPath)) continue;
            return entries[i];
        }
        return null;
    }

    public ISVNStatus getSingleStatus(File path) throws SVNClientException {
        return this.getStatus(new File[]{path})[0];
    }

    public ISVNStatus[] getStatus(File[] path) throws SVNClientException {
        ISVNStatus[] statuses = new ISVNStatus[path.length];
        for (int i = 0; i < path.length; ++i) {
            ISVNStatus[] s = this.getStatus(path[i], false, true, false, false);
            statuses[i] = s == null || s.length == 0 ? new SVNStatusUnversioned(path[i]) : s[0];
        }
        return statuses;
    }

    public ISVNStatus[] getStatus(File path, boolean descend, boolean getAll) throws SVNClientException {
        return this.getStatus(path, descend, getAll, false);
    }

    public ISVNStatus[] getStatus(File path, boolean descend, boolean getAll, boolean contactServer) throws SVNClientException {
        return this.getStatus(path, descend, getAll, contactServer, false);
    }

    public ISVNStatus[] getStatus(File path, boolean descend, boolean getAll, boolean contactServer, boolean ignoreExternals) throws SVNClientException {
        this.notificationHandler.setCommand(12);
        String filePathSVN = AbstractJhlClientAdapter.fileToSVNPath(path, false);
        int depth = Depth.unknownOrImmediates((boolean)descend);
        this.notificationHandler.logCommandLine("status " + (contactServer ? "-u " : "") + this.depthCommandLine(depth) + filePathSVN);
        this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(path));
        try {
            MyStatusCallback callback = new MyStatusCallback();
            this.svnClient.status(filePathSVN, depth, contactServer, getAll, getAll, ignoreExternals, null, (StatusCallback)callback);
            return this.processFolderStatuses(this.processExternalStatuses(JhlConverter.convert(callback.getStatusArray())), getAll, contactServer);
        }
        catch (ClientException e) {
            if (e.getAprError() == 155007) {
                return new ISVNStatus[]{new SVNStatusUnversioned(path)};
            }
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    protected JhlStatus[] processExternalStatuses(JhlStatus[] statuses) throws SVNClientException {
        JhlStatus jhlStatus;
        int index;
        ArrayList<Integer> externalStatusesIndexes = new ArrayList<Integer>();
        for (int i = 0; i < statuses.length; ++i) {
            if (!SVNStatusKind.EXTERNAL.equals(statuses[i].getTextStatus())) continue;
            externalStatusesIndexes.add(new Integer(i));
        }
        if (externalStatusesIndexes.isEmpty()) {
            return statuses;
        }
        Iterator iter = externalStatusesIndexes.iterator();
        while (iter.hasNext()) {
            index = (Integer)iter.next();
            jhlStatus = statuses[index];
            for (int i = 0; i < statuses.length; ++i) {
                if (statuses[i].getPath() == null || !statuses[i].getPath().equals(jhlStatus.getPath())) continue;
                statuses[i] = new JhlStatus.JhlStatusExternal(statuses[i]);
                statuses[index] = statuses[i];
            }
        }
        iter = externalStatusesIndexes.iterator();
        while (iter.hasNext()) {
            ISVNInfo info;
            index = (Integer)iter.next();
            jhlStatus = statuses[index];
            if (jhlStatus.getUrlString() != null && jhlStatus.getUrlString().length() != 0 || (info = this.getInfoFromWorkingCopy(jhlStatus.getFile())) == null) continue;
            statuses[index] = new JhlStatus.JhlStatusExternal(jhlStatus, info.getUrlString());
        }
        return statuses;
    }

    protected ISVNStatus[] processFolderStatuses(JhlStatus[] statuses, boolean getAll, boolean contactServer) throws SVNClientException {
        JhlStatus jhlStatus;
        int i;
        if (!getAll || !contactServer) {
            return statuses;
        }
        ArrayList<JhlStatus> folders = new ArrayList<JhlStatus>();
        for (i = 0; i < statuses.length; ++i) {
            jhlStatus = statuses[i];
            if (SVNNodeKind.DIR != jhlStatus.getNodeKind() || jhlStatus.getReposLastChangedRevision() != null) continue;
            folders.add(jhlStatus);
        }
        for (i = 0; i < statuses.length; ++i) {
            jhlStatus = statuses[i];
            if (jhlStatus.getLastChangedRevision() == null) continue;
            Iterator iter = folders.iterator();
            while (iter.hasNext()) {
                JhlStatus folder = (JhlStatus)iter.next();
                if (!jhlStatus.getUrlString().startsWith(folder.getUrlString() + "/") || folder.getLastChangedRevision() != null && folder.getLastChangedRevision().getNumber() >= jhlStatus.getLastChangedRevision().getNumber()) continue;
                folder.updateFromStatus(jhlStatus);
            }
        }
        return statuses;
    }

    public void copy(File srcPath, File destPath) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(6);
            String src = AbstractJhlClientAdapter.fileToSVNPath(srcPath, false);
            String dest = AbstractJhlClientAdapter.fileToSVNPath(destPath, false);
            this.notificationHandler.logCommandLine("copy " + src + " " + dest);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(new File[]{srcPath, destPath}));
            CopySource[] copySources = new CopySource[]{new CopySource(src, Revision.WORKING, Revision.WORKING)};
            this.svnClient.copy(copySources, dest, null, true, true, null);
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public void copy(File srcPath, SVNUrl destUrl, String message) throws SVNClientException {
        try {
            String fixedMessage = this.fixSVNString(message);
            if (fixedMessage == null) {
                fixedMessage = "";
            }
            this.notificationHandler.setCommand(6);
            String src = AbstractJhlClientAdapter.fileToSVNPath(srcPath, false);
            String dest = destUrl.toString();
            this.notificationHandler.logCommandLine("copy " + src + " " + dest);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(srcPath));
            this.svnClient.copy(src, dest, fixedMessage, Revision.WORKING);
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public void copy(File[] srcPaths, SVNUrl destUrl, String message, boolean copyAsChild, boolean makeParents) throws SVNClientException {
        String fixedMessage = this.fixSVNString(message);
        if (srcPaths.length > 1) {
            this.mkdir(destUrl, makeParents, fixedMessage);
            for (int i = 0; i < srcPaths.length; ++i) {
                File[] file = new File[]{srcPaths[i]};
                this.copy(file, destUrl, fixedMessage, copyAsChild, makeParents);
            }
            return;
        }
        try {
            if (fixedMessage == null) {
                fixedMessage = "";
            }
            this.notificationHandler.setCommand(6);
            CopySource[] copySources = new CopySource[srcPaths.length];
            for (int i = 0; i < srcPaths.length; ++i) {
                copySources[i] = new CopySource(AbstractJhlClientAdapter.fileToSVNPath(srcPaths[i], false), Revision.WORKING, Revision.WORKING);
            }
            String dest = destUrl.toString();
            String commandLine = "copy";
            String[] paths = new String[srcPaths.length];
            for (int i = 0; i < srcPaths.length; ++i) {
                paths[i] = AbstractJhlClientAdapter.fileToSVNPath(srcPaths[i], false);
            }
            commandLine = this.appendPaths(commandLine, paths) + " " + dest;
            this.notificationHandler.logCommandLine(commandLine.toString());
            this.notificationHandler.setBaseDir();
            this.svnClient.copy(copySources, dest, fixedMessage, copyAsChild, makeParents, null);
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public void copy(SVNUrl srcUrl, File destPath, SVNRevision revision) throws SVNClientException {
        this.copy(srcUrl, destPath, revision, true, false);
    }

    public void copy(SVNUrl srcUrl, File destPath, SVNRevision revision, boolean copyAsChild, boolean makeParents) throws SVNClientException {
        this.copy(srcUrl, destPath, revision, SVNRevision.HEAD, copyAsChild, makeParents);
    }

    public void copy(SVNUrl srcUrl, File destPath, SVNRevision revision, SVNRevision pegRevision, boolean copyAsChild, boolean makeParents) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(6);
            String dest = AbstractJhlClientAdapter.fileToSVNPath(destPath, false);
            CopySource[] sources = new CopySource[]{new CopySource(srcUrl.toString(), JhlConverter.convert(revision), JhlConverter.convert(pegRevision))};
            this.notificationHandler.logCommandLine("copy " + srcUrl + " " + dest);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(destPath));
            this.svnClient.copy(sources, dest, null, copyAsChild, makeParents, null);
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public void copy(SVNUrl srcUrl, SVNUrl destUrl, String message, SVNRevision revision) throws SVNClientException {
        this.copy(srcUrl, destUrl, message, revision, false);
    }

    public void copy(SVNUrl srcUrl, SVNUrl destUrl, String message, SVNRevision revision, boolean makeParents) throws SVNClientException {
        this.copy(new SVNUrl[]{srcUrl}, destUrl, message, revision, true, makeParents);
    }

    public void copy(SVNUrl[] srcUrls, SVNUrl destUrl, String message, SVNRevision revision, boolean copyAsChild, boolean makeParents) throws SVNClientException {
        try {
            String fixedMessage = this.fixSVNString(message);
            if (fixedMessage == null) {
                fixedMessage = "";
            }
            this.notificationHandler.setCommand(6);
            CopySource[] copySources = new CopySource[srcUrls.length];
            for (int i = 0; i < srcUrls.length; ++i) {
                copySources[i] = new CopySource(srcUrls[i].toString(), JhlConverter.convert(revision), JhlConverter.convert(SVNRevision.HEAD));
            }
            String dest = destUrl.toString();
            String commandLine = "copy -r" + revision.toString();
            String[] paths = new String[srcUrls.length];
            for (int i = 0; i < srcUrls.length; ++i) {
                paths[i] = srcUrls[i].toString();
            }
            commandLine = this.appendPaths(commandLine, paths) + " " + dest;
            this.notificationHandler.logCommandLine(commandLine);
            this.notificationHandler.setBaseDir();
            this.svnClient.copy(copySources, dest, fixedMessage, copyAsChild, makeParents, null);
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public void remove(SVNUrl[] url, String message) throws SVNClientException {
        try {
            String fixedMessage = this.fixSVNString(message);
            if (fixedMessage == null) {
                fixedMessage = "";
            }
            this.notificationHandler.setCommand(7);
            String commandLine = "delete -m \"" + this.getFirstMessageLine(fixedMessage) + "\"";
            String[] targets = new String[url.length];
            for (int i = 0; i < url.length; ++i) {
                targets[i] = url[i].toString();
            }
            commandLine = this.appendPaths(commandLine, targets);
            this.notificationHandler.logCommandLine(commandLine);
            this.notificationHandler.setBaseDir();
            this.svnClient.remove(targets, fixedMessage, false);
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public void remove(File[] file, boolean force) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(7);
            String commandLine = "delete" + (force ? " --force" : "");
            String[] targets = new String[file.length];
            for (int i = 0; i < file.length; ++i) {
                targets[i] = AbstractJhlClientAdapter.fileToSVNPath(file[i], false);
            }
            commandLine = this.appendPaths(commandLine, targets);
            this.notificationHandler.logCommandLine(commandLine);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(file));
            this.svnClient.remove(targets, "", force);
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public void doExport(SVNUrl srcUrl, File destPath, SVNRevision revision, boolean force) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(8);
            String src = srcUrl.toString();
            String dest = AbstractJhlClientAdapter.fileToSVNPath(destPath, false);
            this.notificationHandler.logCommandLine("export -r " + revision.toString() + ' ' + src + ' ' + dest);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(destPath));
            this.svnClient.doExport(src, dest, JhlConverter.convert(revision), force);
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public void doExport(File srcPath, File destPath, boolean force) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(8);
            String src = AbstractJhlClientAdapter.fileToSVNPath(srcPath, false);
            String dest = AbstractJhlClientAdapter.fileToSVNPath(destPath, false);
            this.notificationHandler.logCommandLine("export " + src + ' ' + dest);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(new File[]{srcPath, destPath}));
            this.svnClient.doExport(src, dest, Revision.WORKING, force);
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public void doImport(File path, SVNUrl url, String message, boolean recurse) throws SVNClientException {
        try {
            String fixedMessage = this.fixSVNString(message);
            if (fixedMessage == null) {
                fixedMessage = "";
            }
            this.notificationHandler.setCommand(9);
            String src = AbstractJhlClientAdapter.fileToSVNPath(path, false);
            String dest = url.toString();
            this.notificationHandler.logCommandLine("import -m \"" + this.getFirstMessageLine(fixedMessage) + "\" " + (recurse ? "" : "-N ") + src + ' ' + dest);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(path));
            this.svnClient.doImport(src, dest, fixedMessage, recurse);
            this.notificationHandler.logCompleted(Messages.bind("notify.import.complete"));
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public void mkdir(SVNUrl url, String message) throws SVNClientException {
        this.mkdir(url, false, message);
    }

    public void mkdir(File file) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(10);
            String target = AbstractJhlClientAdapter.fileToSVNPath(file, false);
            this.notificationHandler.logCommandLine("mkdir " + target);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(file));
            this.svnClient.mkdir(new String[]{target}, "");
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public void move(File srcPath, File destPath, boolean force) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(5);
            String src = AbstractJhlClientAdapter.fileToSVNPath(srcPath, false);
            String dest = AbstractJhlClientAdapter.fileToSVNPath(destPath, false);
            this.notificationHandler.logCommandLine("move " + src + ' ' + dest);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(new File[]{srcPath, destPath}));
            this.svnClient.move(src, dest, "", force);
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public void move(SVNUrl srcUrl, SVNUrl destUrl, String message, SVNRevision revision) throws SVNClientException {
        try {
            String fixedMessage = this.fixSVNString(message);
            if (fixedMessage == null) {
                fixedMessage = "";
            }
            this.notificationHandler.setCommand(5);
            String src = srcUrl.toString();
            String dest = destUrl.toString();
            this.notificationHandler.logCommandLine("move -m \"" + this.getFirstMessageLine(fixedMessage) + ' ' + src + ' ' + dest);
            this.notificationHandler.setBaseDir();
            this.svnClient.move(src, dest, fixedMessage, false);
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public long update(File path, SVNRevision revision, boolean recurse) throws SVNClientException {
        return this.update(path, revision, Depth.unknownOrFiles((boolean)recurse), false, false, true);
    }

    public long update(File path, SVNRevision revision, int depth, boolean setDepth, boolean ignoreExternals, boolean force) throws SVNClientException {
        try {
            StringBuffer commandLine;
            this.notificationHandler.setCommand(4);
            String target = AbstractJhlClientAdapter.fileToSVNPath(path, false);
            if (depth == -1) {
                commandLine = new StringBuffer("update " + target + " --set-depth=exclude");
            } else {
                commandLine = new StringBuffer("update " + target + " -r " + revision.toString() + this.depthCommandLine(depth));
                if (ignoreExternals) {
                    commandLine.append(" --ignore-externals");
                }
                if (force) {
                    commandLine.append(" --force");
                }
            }
            this.notificationHandler.logCommandLine(commandLine.toString());
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(path));
            return this.svnClient.update(target, JhlConverter.convert(revision), depth, setDepth, ignoreExternals, force);
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public long[] update(File[] path, SVNRevision revision, boolean recurse, boolean ignoreExternals) throws SVNClientException {
        return this.update(path, revision, Depth.unknownOrFiles((boolean)recurse), false, ignoreExternals, true);
    }

    public long[] update(File[] path, SVNRevision revision, int depth, boolean setDepth, boolean ignoreExternals, boolean force) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(4);
            String[] targets = new String[path.length];
            StringBuffer targetsString = new StringBuffer();
            for (int i = 0; i < targets.length; ++i) {
                targets[i] = AbstractJhlClientAdapter.fileToSVNPath(path[i], false);
                targetsString.append(targets[i]);
                targetsString.append(" ");
            }
            StringBuffer commandLine = new StringBuffer("update " + targetsString.toString() + " -r " + revision.toString() + this.depthCommandLine(depth));
            if (ignoreExternals) {
                commandLine.append(" --ignore-externals");
            }
            if (force) {
                commandLine.append(" --force");
            }
            this.notificationHandler.logCommandLine(commandLine.toString());
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(path));
            this.notificationHandler.holdStats();
            long[] rtnCode = this.svnClient.update(targets, JhlConverter.convert(revision), depth, setDepth, ignoreExternals, force);
            this.notificationHandler.releaseStats();
            return rtnCode;
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public void revert(File path, boolean recurse) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(16);
            String target = AbstractJhlClientAdapter.fileToSVNPath(path, false);
            this.notificationHandler.logCommandLine("revert " + (recurse ? "" : "-N ") + target);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(path));
            this.svnClient.revert(target, recurse);
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public InputStream getContent(SVNUrl url, SVNRevision revision, SVNRevision pegRevision) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(18);
            String commandLine = "cat -r " + revision + " " + url;
            if (pegRevision != null) {
                commandLine = commandLine + "@" + pegRevision;
            }
            this.notificationHandler.logCommandLine(commandLine);
            this.notificationHandler.setBaseDir();
            byte[] contents = this.svnClient.fileContent(url.toString(), JhlConverter.convert(revision), JhlConverter.convert(pegRevision));
            ByteArrayInputStream input = new ByteArrayInputStream(contents);
            return input;
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public InputStream getContent(SVNUrl url, SVNRevision revision) throws SVNClientException {
        return this.getContent(url, revision, SVNRevision.HEAD);
    }

    public InputStream getContent(File path, SVNRevision revision) throws SVNClientException {
        try {
            ISVNStatus status;
            String target = AbstractJhlClientAdapter.fileToSVNPath(path, false);
            this.notificationHandler.setCommand(18);
            this.notificationHandler.logCommandLine("cat -r " + revision.toString() + " " + target);
            this.notificationHandler.setBaseDir();
            if (revision.equals(SVNRevision.BASE) && (status = this.getSingleStatus(path)).getTextStatus().equals(SVNStatusKind.ADDED)) {
                return new ByteArrayInputStream(new byte[0]);
            }
            byte[] contents = this.svnClient.fileContent(target, JhlConverter.convert(revision));
            ByteArrayInputStream input = new ByteArrayInputStream(contents);
            return input;
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public ISVNProperty[] getProperties(File path) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(21);
            String target = AbstractJhlClientAdapter.fileToSVNPath(path, false);
            this.notificationHandler.logCommandLine("proplist " + target);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(path));
            PropertyData[] propertiesData = this.svnClient.properties(target);
            if (propertiesData == null) {
                return new JhlPropertyData[0];
            }
            ISVNProperty[] svnProperties = new JhlPropertyData[propertiesData.length];
            for (int i = 0; i < propertiesData.length; ++i) {
                svnProperties[i] = JhlPropertyData.newForFile(propertiesData[i]);
            }
            return svnProperties;
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public ISVNProperty[] getProperties(SVNUrl url) throws SVNClientException {
        return this.getProperties(url, SVNRevision.HEAD, SVNRevision.HEAD);
    }

    public ISVNProperty[] getProperties(SVNUrl url, SVNRevision revision, SVNRevision pegRevision) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(21);
            String target = url.toString();
            this.notificationHandler.logCommandLine("proplist " + target);
            this.notificationHandler.setBaseDir();
            PropertyData[] propertiesData = this.svnClient.properties(target, JhlConverter.convert(revision), JhlConverter.convert(pegRevision));
            if (propertiesData == null) {
                return new JhlPropertyData[0];
            }
            ISVNProperty[] svnProperties = new JhlPropertyData[propertiesData.length];
            for (int i = 0; i < propertiesData.length; ++i) {
                svnProperties[i] = JhlPropertyData.newForUrl(propertiesData[i]);
            }
            return svnProperties;
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public void propertySet(File path, String propertyName, String propertyValue, boolean recurse) throws SVNClientException {
        try {
            int i;
            ISVNStatus[] statuses;
            this.notificationHandler.setCommand(14);
            String target = AbstractJhlClientAdapter.fileToSVNPath(path, false);
            this.notificationHandler.logCommandLine("propset " + (recurse ? "-R " : "") + propertyName + " \"" + propertyValue + "\" " + target);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(path));
            HashSet<String> statusBefore = null;
            if (recurse) {
                statusBefore = new HashSet<String>();
                statuses = this.getStatus(path, recurse, false);
                for (i = 0; i < statuses.length; ++i) {
                    statusBefore.add(statuses[i].getFile().getAbsolutePath());
                }
            }
            if (propertyName.startsWith("svn:")) {
                this.svnClient.propertySet(target, propertyName, this.fixSVNString(propertyValue), recurse);
            } else {
                this.svnClient.propertySet(target, propertyName, propertyValue, recurse);
            }
            if (recurse) {
                statuses = this.getStatus(path, recurse, false);
                for (i = 0; i < statuses.length; ++i) {
                    String statusPath = statuses[i].getFile().getAbsolutePath();
                    this.notificationHandler.notifyListenersOfChange(statusPath);
                    statusBefore.remove(statusPath);
                }
                Iterator it = statusBefore.iterator();
                while (it.hasNext()) {
                    this.notificationHandler.notifyListenersOfChange((String)it.next());
                }
            } else {
                this.notificationHandler.notifyListenersOfChange(path.getAbsolutePath());
            }
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public void propertySet(File path, String propertyName, File propertyFile, boolean recurse) throws SVNClientException {
        try {
            int i;
            ISVNStatus[] statuses;
            this.notificationHandler.setCommand(14);
            String target = AbstractJhlClientAdapter.fileToSVNPath(path, false);
            this.notificationHandler.logCommandLine("propset " + (recurse ? "-R " : "") + propertyName + "-F \"" + propertyFile.toString() + "\" " + target);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(path));
            byte[] propertyBytes = new byte[(int)propertyFile.length()];
            FileInputStream is = null;
            try {
                is = new FileInputStream(propertyFile);
                is.read(propertyBytes);
            }
            catch (IOException ioe) {
                throw new SVNClientException(ioe);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {}
                }
            }
            HashSet<String> statusBefore = null;
            if (recurse) {
                statusBefore = new HashSet<String>();
                statuses = this.getStatus(path, recurse, false);
                for (i = 0; i < statuses.length; ++i) {
                    statusBefore.add(statuses[i].getFile().getAbsolutePath());
                }
            }
            this.svnClient.propertySet(target, propertyName, propertyBytes, recurse);
            if (recurse) {
                statuses = this.getStatus(path, recurse, false);
                for (i = 0; i < statuses.length; ++i) {
                    String statusPath = statuses[i].getFile().getAbsolutePath();
                    this.notificationHandler.notifyListenersOfChange(statusPath);
                    statusBefore.remove(statusPath);
                }
                Iterator it = statusBefore.iterator();
                while (it.hasNext()) {
                    this.notificationHandler.notifyListenersOfChange((String)it.next());
                }
            } else {
                this.notificationHandler.notifyListenersOfChange(path.getAbsolutePath());
            }
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public ISVNProperty propertyGet(File path, String propertyName) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(20);
            String target = AbstractJhlClientAdapter.fileToSVNPath(path, false);
            this.notificationHandler.logCommandLine("propget " + propertyName + " " + target);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(path));
            PropertyData propData = this.svnClient.propertyGet(target, propertyName);
            if (propData == null) {
                return null;
            }
            return JhlPropertyData.newForFile(propData);
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public ISVNProperty propertyGet(SVNUrl url, SVNRevision revision, SVNRevision peg, String propertyName) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(20);
            String target = url.toString();
            String commandLine = "propget -r " + revision.toString() + " " + propertyName + " " + target;
            if (!peg.equals(SVNRevision.HEAD)) {
                commandLine = commandLine + "@" + peg.toString();
            }
            this.notificationHandler.logCommandLine(commandLine);
            this.notificationHandler.setBaseDir();
            PropertyData propData = this.svnClient.propertyGet(target, propertyName, JhlConverter.convert(revision), JhlConverter.convert(peg));
            if (propData == null) {
                return null;
            }
            return JhlPropertyData.newForUrl(propData);
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public void propertyDel(File path, String propertyName, boolean recurse) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(15);
            String target = AbstractJhlClientAdapter.fileToSVNPath(path, false);
            this.notificationHandler.logCommandLine("propdel " + propertyName + " " + target);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(path));
            HashSet<String> statusBefore = null;
            if (recurse) {
                statusBefore = new HashSet<String>();
                ISVNStatus[] statuses = this.getStatus(path, recurse, false);
                for (int i = 0; i < statuses.length; ++i) {
                    statusBefore.add(statuses[i].getFile().getAbsolutePath());
                }
            }
            PropertyData propData = this.svnClient.propertyGet(target, propertyName);
            propData.remove(recurse);
            if (recurse) {
                ISVNStatus[] statuses = this.getStatus(path, recurse, false);
                for (int i = 0; i < statuses.length; ++i) {
                    String statusPath = statuses[i].getFile().getAbsolutePath();
                    this.notificationHandler.notifyListenersOfChange(statusPath);
                    statusBefore.remove(statusPath);
                }
                Iterator it = statusBefore.iterator();
                while (it.hasNext()) {
                    this.notificationHandler.notifyListenersOfChange((String)it.next());
                }
            } else {
                this.notificationHandler.notifyListenersOfChange(path.getAbsolutePath());
            }
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public void diff(File oldPath, SVNRevision oldPathRevision, File newPath, SVNRevision newPathRevision, File outFile, boolean recurse) throws SVNClientException {
        this.diff(oldPath, oldPathRevision, newPath, newPathRevision, outFile, recurse, true, false, false);
    }

    private void diffRelative(File oldPath, SVNRevision oldPathRevision, File newPath, SVNRevision newPathRevision, File outFile, boolean recurse, boolean ignoreAncestry, boolean noDiffDeleted, boolean force, File relativeTo) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(17);
            if (oldPath == null) {
                oldPath = new File(".");
            }
            if (newPath == null) {
                newPath = oldPath;
            }
            if (oldPathRevision == null) {
                oldPathRevision = SVNRevision.BASE;
            }
            if (newPathRevision == null) {
                newPathRevision = SVNRevision.WORKING;
            }
            String oldTarget = AbstractJhlClientAdapter.fileToSVNPath(oldPath, false);
            String newTarget = AbstractJhlClientAdapter.fileToSVNPath(newPath, false);
            String svnOutFile = AbstractJhlClientAdapter.fileToSVNPath(outFile, false);
            String relativeToDir = AbstractJhlClientAdapter.fileToSVNPath(relativeTo, false);
            String commandLine = "diff ";
            if (oldPathRevision.getKind() != 5 || newPathRevision.getKind() != 6) {
                commandLine = commandLine + "-r " + oldPathRevision.toString();
                if (newPathRevision.getKind() != 6) {
                    commandLine = commandLine + ":" + newPathRevision.toString();
                }
                commandLine = commandLine + " ";
            }
            if (!oldPath.equals(new File("."))) {
                commandLine = commandLine + "--old " + oldTarget + " ";
            }
            if (!newPath.equals(oldPath)) {
                commandLine = commandLine + "--new " + newTarget + " ";
            }
            int depth = 0;
            if (recurse) {
                depth = 3;
            } else if (oldPath.isFile()) {
                depth = 1;
            }
            this.notificationHandler.logCommandLine(commandLine);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(new File[]{oldPath, newPath}));
            this.svnClient.diff(oldTarget, JhlConverter.convert(oldPathRevision), newTarget, JhlConverter.convert(newPathRevision), relativeToDir, svnOutFile, depth, null, ignoreAncestry, noDiffDeleted, force);
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public void diff(File oldPath, SVNRevision oldPathRevision, File newPath, SVNRevision newPathRevision, File outFile, boolean recurse, boolean ignoreAncestry, boolean noDiffDeleted, boolean force) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(17);
            if (oldPath == null) {
                oldPath = new File(".");
            }
            if (newPath == null) {
                newPath = oldPath;
            }
            if (oldPathRevision == null) {
                oldPathRevision = SVNRevision.BASE;
            }
            if (newPathRevision == null) {
                newPathRevision = SVNRevision.WORKING;
            }
            String oldTarget = AbstractJhlClientAdapter.fileToSVNPath(oldPath, false);
            String newTarget = AbstractJhlClientAdapter.fileToSVNPath(newPath, false);
            String svnOutFile = AbstractJhlClientAdapter.fileToSVNPath(outFile, false);
            String commandLine = "diff ";
            if (oldPathRevision.getKind() != 5 || newPathRevision.getKind() != 6) {
                commandLine = commandLine + "-r " + oldPathRevision.toString();
                if (newPathRevision.getKind() != 6) {
                    commandLine = commandLine + ":" + newPathRevision.toString();
                }
                commandLine = commandLine + " ";
            }
            if (!oldPath.equals(new File("."))) {
                commandLine = commandLine + "--old " + oldTarget + " ";
            }
            if (!newPath.equals(oldPath)) {
                commandLine = commandLine + "--new " + newTarget + " ";
            }
            this.notificationHandler.logCommandLine(commandLine);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(new File[]{oldPath, newPath}));
            this.svnClient.diff(oldTarget, JhlConverter.convert(oldPathRevision), newTarget, JhlConverter.convert(newPathRevision), svnOutFile, recurse, ignoreAncestry, noDiffDeleted, force);
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public void diff(File path, File outFile, boolean recurse) throws SVNClientException {
        this.diff(path, null, null, null, outFile, recurse);
    }

    public void diff(SVNUrl oldUrl, SVNRevision oldUrlRevision, SVNUrl newUrl, SVNRevision newUrlRevision, File outFile, boolean recurse) throws SVNClientException {
        this.diff(oldUrl, oldUrlRevision, newUrl, newUrlRevision, outFile, recurse, true, false, false);
    }

    public void diff(SVNUrl target, SVNRevision pegRevision, SVNRevision startRevision, SVNRevision endRevision, File outFile, int depth, boolean ignoreAncestry, boolean noDiffDeleted, boolean force) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(17);
            if (pegRevision == null) {
                pegRevision = SVNRevision.HEAD;
            }
            if (startRevision == null) {
                startRevision = SVNRevision.HEAD;
            }
            if (endRevision == null) {
                endRevision = SVNRevision.HEAD;
            }
            String commandLine = "diff ";
            commandLine = commandLine + this.depthCommandLine(depth);
            if (ignoreAncestry) {
                commandLine = commandLine + " --ignoreAncestry";
            }
            commandLine = commandLine + " -r " + startRevision + ":" + endRevision + " " + target;
            this.notificationHandler.logCommandLine(commandLine);
            this.notificationHandler.setBaseDir();
            this.svnClient.diff(target.toString(), JhlConverter.convert(pegRevision), JhlConverter.convert(startRevision), JhlConverter.convert(endRevision), null, outFile.getAbsolutePath(), depth, null, ignoreAncestry, noDiffDeleted, force);
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public void diff(SVNUrl target, SVNRevision pegRevision, SVNRevision startRevision, SVNRevision endRevision, File outFile, boolean recurse) throws SVNClientException {
        this.diff(target, pegRevision, startRevision, endRevision, outFile, Depth.infinityOrImmediates((boolean)recurse), true, false, false);
    }

    public void diff(SVNUrl oldUrl, SVNRevision oldUrlRevision, SVNUrl newUrl, SVNRevision newUrlRevision, File outFile, boolean recurse, boolean ignoreAncestry, boolean noDiffDeleted, boolean force) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(17);
            if (newUrl == null) {
                newUrl = oldUrl;
            }
            if (oldUrlRevision == null) {
                oldUrlRevision = SVNRevision.HEAD;
            }
            if (newUrlRevision == null) {
                newUrlRevision = SVNRevision.HEAD;
            }
            String svnOutFile = AbstractJhlClientAdapter.fileToSVNPath(outFile, false);
            String commandLine = "diff ";
            if (oldUrlRevision.getKind() != 7 || newUrlRevision.getKind() != 7) {
                commandLine = commandLine + "-r " + oldUrlRevision.toString();
                if (newUrlRevision.getKind() != 7) {
                    commandLine = commandLine + ":" + newUrlRevision.toString();
                }
                commandLine = commandLine + " ";
            }
            commandLine = commandLine + oldUrl + " ";
            if (!newUrl.equals(oldUrl)) {
                commandLine = commandLine + newUrl + " ";
            }
            this.notificationHandler.logCommandLine(commandLine);
            this.notificationHandler.setBaseDir();
            this.svnClient.diff(oldUrl.toString(), JhlConverter.convert(oldUrlRevision), newUrl.toString(), JhlConverter.convert(newUrlRevision), svnOutFile, recurse, ignoreAncestry, noDiffDeleted, force);
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public void diff(SVNUrl url, SVNRevision oldUrlRevision, SVNRevision newUrlRevision, File outFile, boolean recurse) throws SVNClientException {
        this.diff(url, oldUrlRevision, url, newUrlRevision, outFile, recurse);
    }

    public ISVNAnnotations annotate(File file, SVNRevision revisionStart, SVNRevision revisionEnd, boolean ignoreMimeType, boolean includeMergedRevisions) throws SVNClientException {
        return this.annotate(file, revisionStart, revisionEnd, null, ignoreMimeType, includeMergedRevisions);
    }

    public ISVNAnnotations annotate(File file, SVNRevision revisionStart, SVNRevision revisionEnd, SVNRevision pegRevision, boolean ignoreMimeType, boolean includeMergedRevisions) throws SVNClientException {
        String target = AbstractJhlClientAdapter.fileToSVNPath(file, false);
        ISVNInfo info = this.getInfoFromWorkingCopy(file);
        if (SVNScheduleKind.ADD == info.getSchedule() && info.getCopyUrl() != null) {
            target = info.getCopyUrl().toString();
        }
        return this.annotate(target, revisionStart, revisionEnd, pegRevision, ignoreMimeType, includeMergedRevisions);
    }

    public ISVNAnnotations annotate(SVNUrl url, SVNRevision revisionStart, SVNRevision revisionEnd, SVNRevision pegRevision, boolean ignoreMimeType, boolean includeMergedRevisions) throws SVNClientException {
        return this.annotate(url.toString(), revisionStart, revisionEnd, pegRevision, ignoreMimeType, includeMergedRevisions);
    }

    private ISVNAnnotations annotate(String target, SVNRevision revisionStart, SVNRevision revisionEnd, SVNRevision pegRevision, boolean ignoreMimeType, boolean includeMergedRevisions) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(25);
            if (revisionStart == null) {
                revisionStart = new SVNRevision.Number(1L);
            }
            if (revisionEnd == null) {
                revisionEnd = SVNRevision.HEAD;
            }
            if (pegRevision == null) {
                pegRevision = SVNRevision.HEAD;
            }
            String commandLine = "blame ";
            if (includeMergedRevisions) {
                commandLine = commandLine + "-g ";
            }
            commandLine = commandLine + "-r " + revisionStart.toString() + ":" + revisionEnd.toString() + " ";
            commandLine = commandLine + target + "@" + pegRevision;
            this.notificationHandler.logCommandLine(commandLine);
            this.notificationHandler.setBaseDir();
            JhlAnnotations annotations = new JhlAnnotations();
            this.svnClient.blame(target, JhlConverter.convert(pegRevision), JhlConverter.convert(revisionStart), JhlConverter.convert(revisionEnd), ignoreMimeType, includeMergedRevisions, (BlameCallback2)annotations);
            return annotations;
        }
        catch (ClientException e) {
            if (includeMergedRevisions && e.getAprError() == 200007) {
                return this.annotate(target, revisionStart, revisionEnd, pegRevision, ignoreMimeType, false);
            }
            if (e.getAprError() == 160013 && pegRevision != null && !pegRevision.equals(revisionEnd)) {
                return this.annotate(target, revisionStart, pegRevision, pegRevision, ignoreMimeType, includeMergedRevisions);
            }
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public ISVNAnnotations annotate(SVNUrl url, SVNRevision revisionStart, SVNRevision revisionEnd) throws SVNClientException {
        return this.annotate(url.toString(), revisionStart, revisionEnd, null, false, false);
    }

    public ISVNAnnotations annotate(File file, SVNRevision revisionStart, SVNRevision revisionEnd) throws SVNClientException {
        String target = AbstractJhlClientAdapter.fileToSVNPath(file, false);
        ISVNInfo info = this.getInfoFromWorkingCopy(file);
        if (SVNScheduleKind.ADD == info.getSchedule() && info.getCopyUrl() != null) {
            target = info.getCopyUrl().toString();
        }
        return this.annotate(target, revisionStart, revisionEnd, null, false, false);
    }

    public void resolved(File path) throws SVNClientException {
        this.resolve(path, 6);
    }

    public void resolve(File path, int result) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(31);
            String target = AbstractJhlClientAdapter.fileToSVNPath(path, true);
            String commandLine = "resolve ";
            switch (result) {
                case 6: {
                    commandLine = commandLine + "--accept=working ";
                    break;
                }
                case 1: {
                    commandLine = commandLine + "--accept=base ";
                    break;
                }
                case 2: {
                    commandLine = commandLine + "--accept=theirs-full ";
                    break;
                }
                case 3: {
                    commandLine = commandLine + "--accept=mine-full ";
                    break;
                }
            }
            commandLine = commandLine + target;
            this.notificationHandler.logCommandLine(commandLine);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(path));
            this.svnClient.resolve(target, 0, result);
        }
        catch (SubversionException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public void cancelOperation() throws SVNClientException {
        try {
            this.svnClient.cancelOperation();
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public ISVNInfo getInfoFromWorkingCopy(File path) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(19);
            String target = AbstractJhlClientAdapter.fileToSVNPath(path, false);
            this.notificationHandler.logCommandLine("info " + target);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(path));
            Info info = this.svnClient.info(target);
            if (info == null) {
                return new SVNInfoUnversioned(path);
            }
            return new JhlInfo(path, info);
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public ISVNInfo getInfo(File path) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(19);
            String target = AbstractJhlClientAdapter.fileToSVNPath(path, false);
            this.notificationHandler.logCommandLine("info " + target);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(path));
            Info info = this.svnClient.info(target);
            if (info == null) {
                return new SVNInfoUnversioned(path);
            }
            if (info.getLastChangedRevision() == -1L) {
                return new JhlInfo(path, info);
            }
            Info2[] info2 = this.svnClient.info2(target, Revision.HEAD, Revision.HEAD, false);
            if (info2 == null || info2.length == 0) {
                return new SVNInfoUnversioned(path);
            }
            return new JhlInfo2(path, info2[0]);
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public ISVNInfo[] getInfo(File path, boolean descend) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(19);
            String target = AbstractJhlClientAdapter.fileToSVNPath(path, false);
            if (descend) {
                this.notificationHandler.logCommandLine("info " + target + " --depth=infinity");
            } else {
                this.notificationHandler.logCommandLine("info " + target);
            }
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(path));
            ArrayList<ISVNInfo> infoList = new ArrayList<ISVNInfo>();
            Info info = this.svnClient.info(target);
            if (info == null) {
                infoList.add(new SVNInfoUnversioned(path));
            } else {
                Info2[] infos = this.svnClient.info2(target, null, null, true);
                if (infos == null || infos.length == 0) {
                    infoList.add(new SVNInfoUnversioned(path));
                } else {
                    for (int i = 0; i < infos.length; ++i) {
                        infoList.add(new JhlInfo2(path, infos[i]));
                    }
                }
            }
            ISVNInfo[] infoArray = new ISVNInfo[infoList.size()];
            infoList.toArray(infoArray);
            return infoArray;
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public ISVNInfo getInfo(SVNUrl url, SVNRevision revision, SVNRevision peg) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(19);
            String target = url.toString();
            this.notificationHandler.logCommandLine("info " + target);
            Info2[] info = this.svnClient.info2(target, JhlConverter.convert(revision), JhlConverter.convert(peg), false);
            if (info == null || info.length == 0) {
                return new SVNInfoUnversioned(null);
            }
            return new JhlInfo2(null, info[0]);
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public void switchToUrl(File path, SVNUrl url, SVNRevision revision, boolean recurse) throws SVNClientException {
        this.switchToUrl(path, url, revision, Depth.unknownOrFiles((boolean)recurse), false, false, true);
    }

    public void switchToUrl(File path, SVNUrl url, SVNRevision revision, int depth, boolean setDepth, boolean ignoreExternals, boolean force) throws SVNClientException {
        this.switchToUrl(path, url, revision, revision, depth, setDepth, ignoreExternals, force);
    }

    public void switchToUrl(File path, SVNUrl url, SVNRevision revision, SVNRevision pegRevision, int depth, boolean setDepth, boolean ignoreExternals, boolean force) throws SVNClientException {
        if (depth == -1) {
            this.update(path, pegRevision, depth, true, ignoreExternals, force);
            return;
        }
        try {
            this.notificationHandler.setCommand(26);
            String target = AbstractJhlClientAdapter.fileToSVNPath(path, false);
            StringBuffer commandLine = new StringBuffer("switch " + url + " " + target + " -r " + revision.toString() + this.depthCommandLine(depth));
            if (ignoreExternals) {
                commandLine.append(" --ignore-externals");
            }
            if (force) {
                commandLine.append(" --force");
            }
            this.notificationHandler.logCommandLine(commandLine.toString());
            File baseDir = SVNBaseDir.getBaseDir(path);
            this.notificationHandler.setBaseDir(baseDir);
            Revision rev = JhlConverter.convert(revision);
            Revision pegRev = JhlConverter.convert(pegRevision);
            this.svnClient.doSwitch(target, url.toString(), rev, pegRev, depth, setDepth, ignoreExternals, force);
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public void setConfigDirectory(File dir) throws SVNClientException {
        try {
            this.svnClient.setConfigDirectory(AbstractJhlClientAdapter.fileToSVNPath(dir, false));
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public void cleanup(File path) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(24);
            String target = AbstractJhlClientAdapter.fileToSVNPath(path, false);
            String commandLine = "cleanup " + target;
            this.notificationHandler.logCommandLine(commandLine);
            this.svnClient.cleanup(target);
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public void merge(SVNUrl path1, SVNRevision revision1, SVNUrl path2, SVNRevision revision2, File localPath, boolean force, boolean recurse, boolean dryRun, boolean ignoreAncestry) throws SVNClientException {
        this.merge(path1, revision1, path2, revision2, localPath, force, Depth.infinityOrFiles((boolean)recurse), dryRun, ignoreAncestry, false);
    }

    public void merge(SVNUrl path1, SVNRevision revision1, SVNUrl path2, SVNRevision revision2, SVNRevision pegRevision, File localPath, boolean force, int depth, boolean dryRun, boolean ignoreAncestry, boolean recordOnly) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(27);
            String target = AbstractJhlClientAdapter.fileToSVNPath(localPath, false);
            String commandLine = "merge";
            boolean samePath = false;
            if (dryRun) {
                commandLine = commandLine + " --dry-run";
            }
            commandLine = commandLine + this.depthCommandLine(depth);
            if (force) {
                commandLine = commandLine + " --force";
            }
            if (ignoreAncestry) {
                commandLine = commandLine + " --ignore-ancestry";
            }
            if (path1.toString().equals(path2.toString())) {
                samePath = true;
                commandLine = revision1 == null || revision2 == null ? commandLine + " " + path1 : commandLine + " -r" + revision1.toString() + ":" + revision2.toString() + " " + path1;
            } else {
                commandLine = commandLine + " " + path1 + "@" + revision1.toString() + " " + path2 + "@" + revision2.toString();
            }
            commandLine = commandLine + " " + target;
            this.notificationHandler.logCommandLine(commandLine);
            File baseDir = SVNBaseDir.getBaseDir(localPath);
            this.notificationHandler.setBaseDir(baseDir);
            if (samePath) {
                Revision rev1 = revision1 == null ? Revision.START : JhlConverter.convert(revision1);
                Revision rev2 = revision2 == null ? Revision.START : JhlConverter.convert(revision2);
                RevisionRange[] revisionRanges = new RevisionRange[]{new RevisionRange(rev1, rev2)};
                this.svnClient.merge(path1.toString(), JhlConverter.convert(pegRevision), revisionRanges, target, force, depth, ignoreAncestry, dryRun, recordOnly);
            } else {
                this.svnClient.merge(path1.toString(), JhlConverter.convert(revision1), path2.toString(), JhlConverter.convert(revision2), target, force, depth, ignoreAncestry, dryRun, recordOnly);
            }
            if (dryRun) {
                this.notificationHandler.logCompleted("Dry-run merge complete.");
            } else {
                this.notificationHandler.logCompleted("Merge complete.");
            }
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            if (dryRun) {
                this.notificationHandler.logCompleted("Dry-run merge completed abnormally.");
            } else {
                this.notificationHandler.logCompleted("Merge completed abnormally.");
            }
            SVNClientException svnClientException = new SVNClientException(e);
            svnClientException.setAprError(e.getAprError());
            throw svnClientException;
        }
    }

    public void merge(SVNUrl path1, SVNRevision revision1, SVNUrl path2, SVNRevision revision2, File localPath, boolean force, int depth, boolean dryRun, boolean ignoreAncestry, boolean recordOnly) throws SVNClientException {
        SVNUrlWithPegRevision svnUrlWithPegRevision = new SVNUrlWithPegRevision(path1);
        SVNRevision pegRevision = svnUrlWithPegRevision.getPegRevision();
        if (pegRevision == null) {
            pegRevision = revision2 == null ? SVNRevision.HEAD : revision2;
        }
        this.merge(svnUrlWithPegRevision.getUrl(), revision1, new SVNUrlWithPegRevision(path2).getUrl(), revision2, pegRevision, localPath, force, depth, dryRun, ignoreAncestry, recordOnly);
    }

    public void mergeReintegrate(SVNUrl path, SVNRevision pegRevision, File localPath, boolean force, boolean dryRun) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(27);
            String target = AbstractJhlClientAdapter.fileToSVNPath(localPath, false);
            String commandLine = "merge --reintegrate";
            if (dryRun) {
                commandLine = commandLine + " --dry-run";
            }
            if (force) {
                commandLine = commandLine + " --force";
            }
            commandLine = commandLine + " " + path + " " + target;
            this.notificationHandler.logCommandLine(commandLine);
            File baseDir = SVNBaseDir.getBaseDir(localPath);
            this.notificationHandler.setBaseDir(baseDir);
            Revision peg = JhlConverter.convert(pegRevision);
            if (peg == null) {
                peg = Revision.HEAD;
            }
            this.svnClient.mergeReintegrate(path.toString(), peg, target, dryRun);
            if (dryRun) {
                this.notificationHandler.logCompleted("Dry-run merge complete.");
            } else {
                this.notificationHandler.logCompleted("Merge complete.");
            }
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            if (dryRun) {
                this.notificationHandler.logCompleted("Dry-run merge completed abnormally.");
            } else {
                this.notificationHandler.logCompleted("Merge completed abnormally.");
            }
            SVNClientException svnClientException = new SVNClientException(e);
            svnClientException.setAprError(e.getAprError());
            throw svnClientException;
        }
    }

    public void addPasswordCallback(ISVNPromptUserPassword callback) {
        if (callback != null) {
            JhlPromptUserPassword prompt = new JhlPromptUserPassword(callback);
            this.setPromptUserPassword((PromptUserPassword)prompt);
        }
    }

    public void lock(SVNUrl[] uris, String comment, boolean force) throws SVNClientException {
        this.notImplementedYet();
    }

    public void unlock(SVNUrl[] uris, boolean force) throws SVNClientException {
        this.notImplementedYet();
    }

    public void lock(File[] paths, String comment, boolean force) throws SVNClientException {
        try {
            int i;
            this.notificationHandler.setCommand(28);
            String[] files = new String[paths.length];
            String commandLine = "lock -m \"" + comment + "\"";
            if (force) {
                commandLine = commandLine + " --force";
            }
            for (i = 0; i < paths.length; ++i) {
                files[i] = AbstractJhlClientAdapter.fileToSVNPath(paths[i], false);
            }
            commandLine = this.appendPaths(commandLine, files);
            this.notificationHandler.logCommandLine(commandLine);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(paths));
            this.svnClient.lock(files, comment, force);
            for (i = 0; i < files.length; ++i) {
                this.notificationHandler.notifyListenersOfChange(files[i]);
            }
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
        }
    }

    public void unlock(File[] paths, boolean force) throws SVNClientException {
        try {
            int i;
            this.notificationHandler.setCommand(28);
            String[] files = new String[paths.length];
            String commandLine = "unlock ";
            if (force) {
                commandLine = commandLine + " --force";
            }
            for (i = 0; i < paths.length; ++i) {
                files[i] = AbstractJhlClientAdapter.fileToSVNPath(paths[i], false);
            }
            commandLine = this.appendPaths(commandLine, files);
            this.notificationHandler.logCommandLine(commandLine);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(paths));
            this.svnClient.unlock(files, force);
            for (i = 0; i < files.length; ++i) {
                this.notificationHandler.notifyListenersOfChange(files[i]);
            }
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
        }
    }

    public void setRevProperty(SVNUrl url, SVNRevision.Number revisionNo, String propName, String propertyData, boolean force) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(14);
            this.notificationHandler.logCommandLine("propset --revprop -r " + revisionNo.toString() + (force ? " --force " : "") + " \"" + propName + "\"  \"" + propertyData + "\" " + url.toString());
            this.notificationHandler.setBaseDir();
            if (propName.startsWith("svn:")) {
                this.svnClient.setRevProperty(url.toString(), propName, Revision.getInstance((long)revisionNo.getNumber()), this.fixSVNString(propertyData), true);
            } else {
                this.svnClient.setRevProperty(url.toString(), propName, Revision.getInstance((long)revisionNo.getNumber()), propertyData, true);
            }
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public String getRevProperty(SVNUrl url, SVNRevision.Number revisionNo, String propName) throws SVNClientException {
        String propData = null;
        try {
            this.notificationHandler.setCommand(20);
            this.notificationHandler.logCommandLine("propget --revprop -r " + revisionNo.toString() + " \"" + propName + "\"  " + url.toString());
            this.notificationHandler.setBaseDir();
            PropertyData temp = this.svnClient.revProperty(url.toString(), propName, Revision.getInstance((long)revisionNo.getNumber()));
            propData = temp.getValue();
            if (propName.startsWith("svn:")) {
                this.fixSVNString(propData);
            }
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
        return propData;
    }

    public ISVNProperty[] getRevProperties(SVNUrl url, SVNRevision.Number revisionNo) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(21);
            String target = url.toString();
            this.notificationHandler.logCommandLine("proplist --revprop -r " + revisionNo.toString() + target);
            this.notificationHandler.setBaseDir();
            PropertyData[] propertiesData = this.svnClient.revProperties(target, Revision.getInstance((long)revisionNo.getNumber()));
            if (propertiesData == null) {
                return new JhlPropertyData[0];
            }
            ISVNProperty[] svnProperties = new JhlPropertyData[propertiesData.length];
            for (int i = 0; i < propertiesData.length; ++i) {
                svnProperties[i] = JhlPropertyData.newForUrl(propertiesData[i]);
            }
            return svnProperties;
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public String getAdminDirectoryName() {
        return this.svnClient.getAdminDirectoryName();
    }

    public boolean isAdminDirectory(String name) {
        return this.svnClient.isAdminDirectory(name);
    }

    private void getLogMessages(String target, SVNRevision pegRevision, SVNRevision revisionStart, SVNRevision revisionEnd, boolean stopOnCopy, boolean fetchChangePath, long limit, boolean includeMergedRevisions, String[] requestedProperties, ISVNLogMessageCallback worker) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(13);
            String logExtras = "";
            if (includeMergedRevisions) {
                logExtras = logExtras + " -g";
            }
            if (stopOnCopy) {
                logExtras = logExtras + " --stop-on-copy";
            }
            if (limit > 0L) {
                logExtras = logExtras + " --limit " + limit;
            }
            this.notificationHandler.logCommandLine("log -r " + revisionStart.toString() + ":" + revisionEnd.toString() + " " + target + logExtras);
            JhlLogMessageCallback callback = new JhlLogMessageCallback(worker);
            this.svnClient.logMessages(target, JhlConverter.convert(pegRevision), JhlConverter.convert(revisionStart), JhlConverter.convert(revisionEnd), stopOnCopy, fetchChangePath, includeMergedRevisions, requestedProperties, limit, (LogMessageCallback)callback);
        }
        catch (ClientException e) {
            if (e.getAprError() == 200007 && includeMergedRevisions) {
                this.getLogMessages(target, pegRevision, revisionStart, revisionEnd, stopOnCopy, fetchChangePath, limit, false, requestedProperties, worker);
            }
            if (e.getAprError() == 160013 && pegRevision != null && !pegRevision.equals(revisionStart)) {
                this.getLogMessages(target, pegRevision, pegRevision, revisionEnd, stopOnCopy, fetchChangePath, limit, includeMergedRevisions, requestedProperties, worker);
            }
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public void getLogMessages(File path, SVNRevision pegRevision, SVNRevision revisionStart, SVNRevision revisionEnd, boolean stopOnCopy, boolean fetchChangePath, long limit, boolean includeMergedRevisions, String[] requestedProperties, ISVNLogMessageCallback worker) throws SVNClientException {
        String target = AbstractJhlClientAdapter.fileToSVNPath(path, false);
        this.notificationHandler.setBaseDir();
        this.getLogMessages(target, pegRevision, revisionStart, revisionEnd, stopOnCopy, fetchChangePath, limit, includeMergedRevisions, requestedProperties, worker);
    }

    public void getLogMessages(SVNUrl url, SVNRevision pegRevision, SVNRevision revisionStart, SVNRevision revisionEnd, boolean stopOnCopy, boolean fetchChangePath, long limit, boolean includeMergedRevisions, String[] requestedProperties, ISVNLogMessageCallback worker) throws SVNClientException {
        String target = url.toString();
        this.notificationHandler.setBaseDir();
        this.getLogMessages(target, pegRevision, revisionStart, revisionEnd, stopOnCopy, fetchChangePath, limit, includeMergedRevisions, requestedProperties, worker);
    }

    public void relocate(String from, String to, String path, boolean recurse) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(30);
            if (recurse) {
                this.notificationHandler.logCommandLine("switch --relocate " + from + " " + to + " " + path);
            } else {
                this.notificationHandler.logCommandLine("switch --relocate -N" + from + " " + to + " " + path);
            }
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(new File(path)));
            this.svnClient.relocate(from, to, path, recurse);
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public void diff(File path, SVNUrl url, SVNRevision urlRevision, File outFile, boolean recurse) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(17);
            String wcPath = AbstractJhlClientAdapter.fileToSVNPath(path, false);
            String svnOutFile = AbstractJhlClientAdapter.fileToSVNPath(outFile, false);
            String commandLine = "diff --old " + wcPath + " ";
            commandLine = commandLine + "--new " + url.toString();
            if (!urlRevision.equals(SVNRevision.HEAD)) {
                commandLine = commandLine + "@" + urlRevision.toString();
            }
            this.notificationHandler.logCommandLine(commandLine);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(path));
            this.svnClient.diff(wcPath, Revision.WORKING, url.toString(), JhlConverter.convert(urlRevision), svnOutFile, recurse);
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public void mkdir(SVNUrl url, boolean makeParents, String message) throws SVNClientException {
        try {
            String fixedMessage = this.fixSVNString(message);
            if (fixedMessage == null) {
                fixedMessage = "";
            }
            this.notificationHandler.setCommand(10);
            String target = url.toString();
            if (makeParents) {
                this.notificationHandler.logCommandLine("mkdir --parents -m \"" + this.getFirstMessageLine(fixedMessage) + "\" " + target);
            } else {
                this.notificationHandler.logCommandLine("mkdir -m \"" + this.getFirstMessageLine(fixedMessage) + "\" " + target);
            }
            this.notificationHandler.setBaseDir();
            this.svnClient.mkdir(new String[]{target}, fixedMessage, makeParents, null);
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public void merge(SVNUrl url, SVNRevision pegRevision, SVNRevisionRange[] revisions, File localPath, boolean force, int depth, boolean ignoreAncestry, boolean dryRun, boolean recordOnly) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(27);
            String target = AbstractJhlClientAdapter.fileToSVNPath(localPath, false);
            String commandLine = "merge";
            if (dryRun) {
                commandLine = commandLine + " --dry-run";
            }
            commandLine = commandLine + this.depthCommandLine(depth);
            if (force) {
                commandLine = commandLine + " --force";
            }
            if (ignoreAncestry) {
                commandLine = commandLine + " --ignore-ancestry";
            }
            RevisionRange[] range = JhlConverter.convert(revisions);
            for (int i = 0; i < revisions.length; ++i) {
                commandLine = commandLine + " " + revisions[i].toMergeString();
            }
            commandLine = commandLine + " " + url.toString();
            commandLine = commandLine + " " + target;
            this.notificationHandler.logCommandLine(commandLine);
            File baseDir = SVNBaseDir.getBaseDir(localPath);
            this.notificationHandler.setBaseDir(baseDir);
            Revision peg = JhlConverter.convert(pegRevision);
            if (peg == null) {
                peg = Revision.HEAD;
            }
            this.svnClient.merge(url.toString(), peg, range, target, force, depth, ignoreAncestry, dryRun, recordOnly);
            if (dryRun) {
                this.notificationHandler.logCompleted("Dry-run merge complete.");
            } else {
                this.notificationHandler.logCompleted("Merge complete.");
            }
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            if (dryRun) {
                this.notificationHandler.logCompleted("Dry-run merge completed abnormally.");
            } else {
                this.notificationHandler.logCompleted("Merge completed abnormally.");
            }
            SVNClientException svnClientException = new SVNClientException(e);
            svnClientException.setAprError(e.getAprError());
            throw svnClientException;
        }
    }

    private String depthCommandLine(int depth) {
        switch (depth) {
            case 0: {
                return " --depth=empty";
            }
            case 1: {
                return " --depth=files";
            }
            case 2: {
                return " --depth=immediates";
            }
            case 3: {
                return " --depth=infinity";
            }
        }
        return "";
    }

    public ISVNMergeInfo getMergeInfo(File path, SVNRevision revision) throws SVNClientException {
        return this.getMergeInfo(AbstractJhlClientAdapter.fileToSVNPath(path, false), JhlConverter.convert(revision));
    }

    public ISVNMergeInfo getMergeInfo(SVNUrl url, SVNRevision revision) throws SVNClientException {
        return this.getMergeInfo(url.toString(), JhlConverter.convert(revision));
    }

    private ISVNMergeInfo getMergeInfo(String path, Revision revision) throws SVNClientException {
        try {
            Mergeinfo info = this.svnClient.getMergeinfo(path, revision);
            if (info == null) {
                return null;
            }
            return new JhlMergeInfo(info);
        }
        catch (SubversionException e) {
            throw new SVNClientException(e);
        }
    }

    public void addConflictResolutionCallback(ISVNConflictResolver callback) {
        this.conflictResolver = callback == null ? null : new JhlConflictResolver(callback);
        this.svnClient.setConflictResolver((ConflictResolverCallback)this.conflictResolver);
    }

    public void setProgressListener(ISVNProgressListener listener) {
        this.progressListener.setWorker(listener);
    }

    private SVNDiffSummary[] diffSummarize(String target1, SVNRevision revision1, String target2, SVNRevision revision2, int depth, boolean ignoreAncestry) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(17);
            if (revision1 == null) {
                revision1 = SVNRevision.HEAD;
            }
            if (revision2 == null) {
                revision2 = SVNRevision.HEAD;
            }
            String commandLine = "diff --summarize";
            commandLine = commandLine + this.depthCommandLine(depth);
            if (ignoreAncestry) {
                commandLine = commandLine + " --ignoreAncestry";
            }
            commandLine = commandLine + " " + target1 + "@" + revision1 + " " + target2 + "@" + revision2;
            this.notificationHandler.logCommandLine(commandLine);
            this.notificationHandler.setBaseDir();
            JhlDiffSummaryReceiver callback = new JhlDiffSummaryReceiver();
            this.svnClient.diffSummarize(target1, JhlConverter.convert(revision1), target2, JhlConverter.convert(revision2), depth, null, ignoreAncestry, (DiffSummaryReceiver)callback);
            return callback.getDiffSummary();
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    private SVNDiffSummary[] diffSummarize(String target, SVNRevision pegRevision, SVNRevision startRevision, SVNRevision endRevision, int depth, boolean ignoreAncestry) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(17);
            if (pegRevision == null) {
                pegRevision = SVNRevision.HEAD;
            }
            if (startRevision == null) {
                startRevision = SVNRevision.HEAD;
            }
            if (endRevision == null) {
                endRevision = SVNRevision.HEAD;
            }
            String commandLine = "diff --summarize";
            commandLine = commandLine + this.depthCommandLine(depth);
            if (ignoreAncestry) {
                commandLine = commandLine + " --ignoreAncestry";
            }
            commandLine = commandLine + " -r " + startRevision + ":" + endRevision + " " + target;
            this.notificationHandler.logCommandLine(commandLine);
            this.notificationHandler.setBaseDir();
            JhlDiffSummaryReceiver callback = new JhlDiffSummaryReceiver();
            this.svnClient.diffSummarize(target, JhlConverter.convert(pegRevision), JhlConverter.convert(startRevision), JhlConverter.convert(endRevision), depth, null, ignoreAncestry, (DiffSummaryReceiver)callback);
            return callback.getDiffSummary();
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public SVNDiffSummary[] diffSummarize(File path, SVNRevision pegRevision, SVNRevision startRevision, SVNRevision endRevision, int depth, boolean ignoreAncestry) throws SVNClientException {
        String target = AbstractJhlClientAdapter.fileToSVNPath(path, false);
        return this.diffSummarize(target, pegRevision, startRevision, endRevision, depth, ignoreAncestry);
    }

    public SVNDiffSummary[] diffSummarize(SVNUrl url, SVNRevision pegRevision, SVNRevision startRevision, SVNRevision endRevision, int depth, boolean ignoreAncestry) throws SVNClientException {
        return this.diffSummarize(url.toString(), pegRevision, startRevision, endRevision, depth, ignoreAncestry);
    }

    public SVNDiffSummary[] diffSummarize(File target1, SVNRevision revision1, SVNUrl target2, SVNRevision revision2, int depth, boolean ignoreAncestry) throws SVNClientException {
        return this.diffSummarize(AbstractJhlClientAdapter.fileToSVNPath(target1, false), revision1, target2.toString(), revision2, depth, ignoreAncestry);
    }

    public SVNDiffSummary[] diffSummarize(SVNUrl target1, SVNRevision revision1, SVNUrl target2, SVNRevision revision2, int depth, boolean ignoreAncestry) throws SVNClientException {
        return this.diffSummarize(target1.toString(), revision1, target2.toString(), revision2, depth, ignoreAncestry);
    }

    public SVNDiffSummary[] diffSummarize(File path, SVNUrl toUrl, SVNRevision toRevision, boolean recurse) throws SVNClientException {
        ArrayList<SVNDiffSummary> diffSummaryList = new ArrayList<SVNDiffSummary>();
        BufferedReader input = null;
        String changedResource = null;
        boolean deletedLines = false;
        boolean addedLines = false;
        boolean contextLines = false;
        boolean oldRev0 = false;
        boolean newRev0 = false;
        boolean propertyChanges = false;
        boolean inDiff = false;
        try {
            SVNDiffSummary diffSummary;
            SVNDiffSummary.SVNDiffKind diffKind;
            File diffFile = File.createTempFile("revision", ".diff");
            diffFile.deleteOnExit();
            this.diff(path, toUrl, toRevision, diffFile, recurse);
            input = new BufferedReader(new FileReader(diffFile));
            String line = null;
            while ((line = input.readLine()) != null) {
                if (line == null || line.trim().length() <= 0 || line.startsWith("\\")) continue;
                if (line.startsWith("Index:")) {
                    if (changedResource != null) {
                        diffKind = this.getDiffKind(changedResource, deletedLines, addedLines, contextLines, oldRev0, newRev0);
                        diffSummary = new SVNDiffSummary(changedResource.substring(path.toString().length() + 1).replaceAll("\\\\", "/"), diffKind, propertyChanges, SVNNodeKind.FILE.toInt());
                        diffSummaryList.add(diffSummary);
                        deletedLines = false;
                        addedLines = false;
                        contextLines = false;
                        propertyChanges = false;
                        oldRev0 = false;
                        newRev0 = false;
                    }
                    inDiff = false;
                    changedResource = line.substring(7);
                    continue;
                }
                if (line.startsWith("--- ")) {
                    if (!line.endsWith("(revision 0)")) continue;
                    oldRev0 = true;
                    continue;
                }
                if (line.startsWith("+++ ")) {
                    if (!line.endsWith("(revision 0)")) continue;
                    newRev0 = true;
                    continue;
                }
                if (line.startsWith("@@")) {
                    inDiff = true;
                    continue;
                }
                if (line.equals("Property changes on: " + changedResource)) {
                    propertyChanges = true;
                    inDiff = false;
                    continue;
                }
                if (!inDiff) continue;
                if (line.startsWith("+")) {
                    addedLines = true;
                    continue;
                }
                if (line.startsWith("-")) {
                    deletedLines = true;
                    continue;
                }
                contextLines = true;
            }
            if (changedResource != null) {
                diffKind = this.getDiffKind(changedResource, deletedLines, addedLines, contextLines, oldRev0, newRev0);
                diffSummary = new SVNDiffSummary(changedResource.substring(path.toString().length() + 1), diffKind, propertyChanges, SVNNodeKind.FILE.toInt());
                diffSummaryList.add(diffSummary);
            }
        }
        catch (Exception e) {
            throw new SVNClientException(e);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {}
            }
        }
        SVNDiffSummary[] diffSummary = new SVNDiffSummary[diffSummaryList.size()];
        diffSummaryList.toArray(diffSummary);
        return diffSummary;
    }

    private SVNDiffSummary.SVNDiffKind getDiffKind(String changedResource, boolean deletedLines, boolean addedLines, boolean contextLines, boolean oldRev0, boolean newRev0) {
        SVNDiffSummary.SVNDiffKind diffKind = oldRev0 && newRev0 ? SVNDiffSummary.SVNDiffKind.DELETED : (addedLines && !deletedLines && !contextLines ? SVNDiffSummary.SVNDiffKind.ADDED : (!deletedLines && !addedLines || deletedLines && !addedLines && !contextLines ? (this.exists(changedResource) ? SVNDiffSummary.SVNDiffKind.DELETED : SVNDiffSummary.SVNDiffKind.ADDED) : SVNDiffSummary.SVNDiffKind.MODIFIED));
        return diffKind;
    }

    private boolean exists(String changedResource) {
        File file = new File(changedResource);
        return file.exists();
    }

    public String[] suggestMergeSources(File path) throws SVNClientException {
        try {
            return this.svnClient.suggestMergeSources(AbstractJhlClientAdapter.fileToSVNPath(path, false), Revision.HEAD);
        }
        catch (SubversionException e) {
            throw new SVNClientException(e);
        }
    }

    public String[] suggestMergeSources(SVNUrl url, SVNRevision peg) throws SVNClientException {
        try {
            return this.svnClient.suggestMergeSources(url.toString(), JhlConverter.convert(peg));
        }
        catch (SubversionException e) {
            throw new SVNClientException(e);
        }
    }

    public void createPatch(File[] paths, File relativeToPath, File outFile, boolean recurse) throws SVNClientException {
        FileOutputStream os = null;
        try {
            File tempFile;
            ArrayList<File> tempFiles = new ArrayList<File>();
            for (int i = 0; i < paths.length; ++i) {
                tempFile = File.createTempFile("tempDiff", ".txt");
                tempFile.deleteOnExit();
                this.diffRelative(paths[i], SVNRevision.BASE, paths[i], SVNRevision.WORKING, tempFile, recurse, false, false, false, relativeToPath);
                tempFiles.add(tempFile);
            }
            os = new FileOutputStream(outFile);
            Iterator iter = tempFiles.iterator();
            while (iter.hasNext()) {
                int bytes_read;
                tempFile = (File)iter.next();
                FileInputStream is = new FileInputStream(tempFile);
                byte[] buffer = new byte[4096];
                while ((bytes_read = is.read(buffer)) != -1) {
                    os.write(buffer, 0, bytes_read);
                }
                is.close();
            }
        }
        catch (Exception e) {
            throw new SVNClientException(e);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public void dispose() {
        this.svnClient.dispose();
    }

    public ISVNLogMessage[] getMergeinfoLog(int kind, File path, SVNRevision pegRevision, SVNUrl mergeSourceUrl, SVNRevision srcPegRevision, boolean discoverChangedPaths) throws SVNClientException {
        return this.getMergeinfoLog(kind, AbstractJhlClientAdapter.fileToSVNPath(path, false), pegRevision, mergeSourceUrl, srcPegRevision, discoverChangedPaths);
    }

    public ISVNLogMessage[] getMergeinfoLog(int kind, SVNUrl url, SVNRevision pegRevision, SVNUrl mergeSourceUrl, SVNRevision srcPegRevision, boolean discoverChangedPaths) throws SVNClientException {
        return this.getMergeinfoLog(kind, url.toString(), pegRevision, mergeSourceUrl, srcPegRevision, discoverChangedPaths);
    }

    private ISVNLogMessage[] getMergeinfoLog(int kind, String target, SVNRevision pegRevision, SVNUrl mergeSourceUrl, SVNRevision srcPegRevision, boolean discoverChangedPaths) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(32);
            String show = "";
            if (kind == 0) {
                show = show + " --show-revs eligible ";
            }
            if (kind == 1) {
                show = show + " --show-revs merged ";
            }
            this.notificationHandler.logCommandLine("mergeinfo " + show + mergeSourceUrl.toString() + " " + target);
            SVNLogMessageCallback worker = new SVNLogMessageCallback();
            JhlLogMessageCallback callback = new JhlLogMessageCallback(worker);
            this.svnClient.getMergeinfoLog(kind, target, JhlConverter.convert(pegRevision), mergeSourceUrl.toString(), JhlConverter.convert(srcPegRevision), discoverChangedPaths, ISVNClientAdapter.DEFAULT_LOG_PROPERTIES, (LogMessageCallback)callback);
            return worker.getLogMessages();
        }
        catch (ClientException e) {
            if (e.getAprError() == 200007) {
                return this.getLogMessages(mergeSourceUrl, srcPegRevision, (SVNRevision)new SVNRevision.Number(0L), SVNRevision.HEAD, true, discoverChangedPaths, 0L, false);
            }
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    private String appendPaths(String commandLine, String[] paths) {
        StringBuffer stringBuffer = new StringBuffer(commandLine);
        if (paths.length > 5) {
            stringBuffer.append(" (" + paths.length + " paths specified)");
        } else {
            for (int i = 0; i < paths.length; ++i) {
                stringBuffer.append(" " + paths[i]);
            }
        }
        return stringBuffer.toString();
    }

    private String getFirstMessageLine(String message) {
        StringTokenizer tokenizer = new StringTokenizer(message, "\n");
        int count = tokenizer.countTokens();
        if (count > 1) {
            return tokenizer.nextToken() + "...";
        }
        return message;
    }

    protected String fixSVNString(String message) {
        if (message == null) {
            return null;
        }
        return message.replaceAll("\r\n", "\n").replaceAll("\r", "\n");
    }

    private class MyStatusCallback
    implements StatusCallback {
        private List statuses = new ArrayList();

        private MyStatusCallback() {
        }

        public void doStatus(Status status) {
            this.statuses.add(status);
        }

        public Status[] getStatusArray() {
            return this.statuses.toArray(new Status[this.statuses.size()]);
        }
    }

    public static class DefaultPromptUserPassword
    implements PromptUserPassword {
        public String askQuestion(String realm, String question, boolean showAnswer) {
            return "";
        }

        public boolean askYesNo(String realm, String question, boolean yesIsDefault) {
            return yesIsDefault;
        }

        public String getPassword() {
            return "";
        }

        public String getUsername() {
            return "";
        }

        public boolean prompt(String realm, String username) {
            return false;
        }
    }
}

