/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter.commandline;

import java.io.InputStream;
import org.tigris.subversion.svnclientadapter.commandline.CmdLineException;
import org.tigris.subversion.svnclientadapter.commandline.CmdLineNotificationHandler;
import org.tigris.subversion.svnclientadapter.commandline.CmdLineNotify;
import org.tigris.subversion.svnclientadapter.commandline.CommandLine;
import org.tigris.subversion.svnclientadapter.commandline.parser.SvnOutputParser;

public class SvnCommandLine
extends CommandLine {
    protected String user;
    protected String pass;
    protected SvnOutputParser svnOutputParser = new SvnOutputParser();
    protected long rev = -1L;
    protected boolean parseSvnOutput = false;
    protected String configDir = null;
    private static final int PARTITIONSIZE = 32;

    SvnCommandLine(String svnPath, CmdLineNotificationHandler notificationHandler) {
        super(svnPath, notificationHandler);
    }

    protected static String validRev(String revision) {
        return revision == null || "".equals(revision) ? "HEAD" : revision;
    }

    void setUsername(String username) {
        this.user = username;
    }

    void setPassword(String password) {
        this.pass = password;
    }

    void setConfigDirectory(String dir) {
        this.configDir = dir;
    }

    String version() throws CmdLineException {
        this.setCommand(0, false);
        return super.version();
    }

    String add(String path, boolean recursive, boolean force) throws CmdLineException {
        this.setCommand(1, true);
        CommandLine.CmdArguments args = this.newCmdArguments("add");
        args.add("-N", !recursive);
        args.add("--force", force);
        args.add(path);
        return this.execString(args, false);
    }

    InputStream cat(String url, String revision) throws CmdLineException {
        this.setCommand(18, false);
        CommandLine.CmdArguments args = this.newCmdArguments("cat");
        args.add("-r");
        args.add(SvnCommandLine.validRev(revision));
        args.add(url);
        args.addAuthInfo(this.user, this.pass);
        args.addConfigInfo(this.configDir);
        return this.execInputStream(args);
    }

    String checkin(String[] path, String message, boolean keepLocks) throws CmdLineException {
        this.setCommand(3, true);
        CommandLine.CmdArguments args = this.newCmdArguments("ci");
        args.add("--no-unlock", keepLocks);
        args.addLogMessage(message);
        args.addAuthInfo(this.user, this.pass);
        args.addConfigInfo(this.configDir);
        for (int i = 0; i < path.length; ++i) {
            args.add(path[i]);
        }
        return this.execString(args, false);
    }

    void cleanup(String path) throws CmdLineException {
        this.setCommand(24, true);
        CommandLine.CmdArguments args = this.newCmdArguments("cleanup");
        args.add(path);
        args.addConfigInfo(this.configDir);
        this.execVoid(args);
    }

    String checkout(String url, String destination, String revision, boolean recursive) throws CmdLineException {
        this.setCommand(2, true);
        CommandLine.CmdArguments args = this.newCmdArguments("co");
        args.add("-r");
        args.add(SvnCommandLine.validRev(revision));
        args.add(url + "@" + SvnCommandLine.validRev(revision));
        args.add(destination);
        if (!recursive) {
            args.add("-N");
        }
        args.addAuthInfo(this.user, this.pass);
        args.addConfigInfo(this.configDir);
        return this.execString(args, false);
    }

    String checkout(String url, String destination, String revision, String depth, boolean ignoreExternals, boolean force) throws CmdLineException {
        this.setCommand(2, true);
        CommandLine.CmdArguments args = this.newCmdArguments("co");
        args.add("-r");
        args.add(SvnCommandLine.validRev(revision));
        args.add(url + "@" + SvnCommandLine.validRev(revision));
        args.add(destination);
        if (depth != null) {
            args.add("--depth");
            args.add(depth);
        }
        args.add("--force", force);
        args.add("--ignore-externals", ignoreExternals);
        args.addAuthInfo(this.user, this.pass);
        args.addConfigInfo(this.configDir);
        return this.execString(args, false);
    }

    void copy(String src, String dest, String message, String revision, boolean makeparents) throws CmdLineException {
        this.setCommand(6, true);
        CommandLine.CmdArguments args = this.newCmdArguments("cp");
        if (revision != null) {
            args.add("-r");
            args.add(SvnCommandLine.validRev(revision));
        }
        args.add("--parents", makeparents);
        if (message != null) {
            args.addLogMessage(message);
        }
        args.add(src);
        args.add(dest);
        args.addAuthInfo(this.user, this.pass);
        args.addConfigInfo(this.configDir);
        this.execVoid(args);
    }

    void copy(String src, String dest) throws CmdLineException {
        this.setCommand(6, true);
        CommandLine.CmdArguments args = this.newCmdArguments("cp");
        args.add(src);
        args.add(dest);
        args.addAuthInfo(this.user, this.pass);
        args.addConfigInfo(this.configDir);
        this.execVoid(args);
    }

    String delete(String[] target, String message, boolean force) throws CmdLineException {
        this.setCommand(7, true);
        CommandLine.CmdArguments args = this.newCmdArguments("rm");
        if (message != null) {
            args.addLogMessage(message);
        }
        args.add("--force", force);
        for (int i = 0; i < target.length; ++i) {
            args.add(target[i]);
        }
        args.addAuthInfo(this.user, this.pass);
        args.addConfigInfo(this.configDir);
        return this.execString(args, false);
    }

    InputStream diff(String oldPath, String oldRev, String newPath, String newRev, boolean recurse, boolean ignoreAncestry, boolean noDiffDeleted, boolean force) throws CmdLineException {
        this.setCommand(17, false);
        CommandLine.CmdArguments args = this.newCmdArguments("diff");
        if (newRev != null) {
            args.add("-r");
            if (newRev.equals("WORKING")) {
                args.add(oldRev);
            } else {
                args.add(oldRev + ":" + newRev);
            }
        }
        args.add("-N", !recurse);
        args.add("--notice-ancestry", !ignoreAncestry);
        args.add("--no-diff-deleted", noDiffDeleted);
        args.add("--force", force);
        args.add("--old");
        args.add(oldPath);
        args.add("--new");
        args.add(newPath);
        args.addConfigInfo(this.configDir);
        return this.execInputStream(args);
    }

    void export(String url, String path, String revision, boolean force) throws CmdLineException {
        this.setCommand(8, true);
        CommandLine.CmdArguments args = this.newCmdArguments("export");
        args.add("-r");
        args.add(SvnCommandLine.validRev(revision));
        args.add(url);
        args.add(path);
        args.add("--force", force);
        args.addConfigInfo(this.configDir);
        this.execVoid(args);
    }

    String importFiles(String path, String url, String message, boolean recursive) throws CmdLineException {
        this.setCommand(9, true);
        CommandLine.CmdArguments args = this.newCmdArguments("import");
        args.add(path);
        args.add(url);
        args.add("-N", !recursive);
        args.addLogMessage(message);
        args.addAuthInfo(this.user, this.pass);
        args.addConfigInfo(this.configDir);
        return this.execString(args, false);
    }

    String info(String[] target, String revision, String peg) throws CmdLineException {
        if (target.length == 0) {
            return "";
        }
        this.setCommand(19, false);
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < target.length; i += 32) {
            CommandLine.CmdArguments args = this.newCmdArguments("info");
            args.addAuthInfo(this.user, this.pass);
            args.addConfigInfo(this.configDir);
            if (revision != null) {
                args.add("-r");
                args.add(revision);
            }
            int j = 0;
            for (int k = i; j < 32 && k < target.length; ++j, ++k) {
                if (peg == null) {
                    args.add(target[k]);
                    continue;
                }
                args.add(target[k] + "@" + peg);
            }
            String partialresult = this.execString(args, false);
            result.append(partialresult);
        }
        return result.toString();
    }

    byte[] list(String url, String revision, boolean recursive) throws CmdLineException {
        this.setCommand(11, false);
        CommandLine.CmdArguments args = this.newCmdArguments("list");
        args.add("-R", recursive);
        args.add("--xml");
        args.add("-r");
        args.add(revision);
        args.add(url);
        args.addAuthInfo(this.user, this.pass);
        args.addConfigInfo(this.configDir);
        return this.execBytes(args, false);
    }

    byte[] log(String target, String revision, boolean stopOnCopy, long limit) throws CmdLineException {
        this.setCommand(13, false);
        CommandLine.CmdArguments args = this.newCmdArguments("log");
        args.add("-r");
        args.add(SvnCommandLine.validRev(revision));
        args.add(target);
        args.add("--xml");
        args.add("--stop-on-copy", stopOnCopy);
        if (limit > 0L) {
            args.add("--limit");
            args.add(Long.toString(limit));
        }
        args.addAuthInfo(this.user, this.pass);
        args.addConfigInfo(this.configDir);
        return this.execBytes(args, true);
    }

    byte[] logVerbose(String target, String[] paths, String revision, boolean stopOnCopy, long limit) throws CmdLineException {
        this.setCommand(13, false);
        CommandLine.CmdArguments args = this.newCmdArguments("log");
        args.add("-r");
        args.add(SvnCommandLine.validRev(revision));
        args.add(target);
        if (paths != null) {
            for (int i = 0; i < paths.length; ++i) {
                args.add(paths[i]);
            }
        }
        args.add("--xml");
        args.add("-v");
        args.add("--stop-on-copy", stopOnCopy);
        if (limit > 0L) {
            args.add("--limit");
            args.add(Long.toString(limit));
        }
        args.addAuthInfo(this.user, this.pass);
        args.addConfigInfo(this.configDir);
        return this.execBytes(args, true);
    }

    void mkdir(String url, String message) throws CmdLineException {
        this.setCommand(10, true);
        CommandLine.CmdArguments args = this.newCmdArguments("mkdir");
        args.addLogMessage(message);
        args.add(url);
        args.addAuthInfo(this.user, this.pass);
        args.addConfigInfo(this.configDir);
        this.execVoid(args);
    }

    void mkdir(String localPath) throws CmdLineException {
        this.setCommand(10, true);
        CommandLine.CmdArguments args = this.newCmdArguments("mkdir");
        args.add(localPath);
        args.addConfigInfo(this.configDir);
        this.execVoid(args);
    }

    String move(String source, String dest, String message, String revision, boolean force) throws CmdLineException {
        this.setCommand(5, true);
        CommandLine.CmdArguments args = this.newCmdArguments("mv");
        args.add("-r");
        args.add(SvnCommandLine.validRev(revision));
        args.add(source);
        args.add(dest);
        if (message != null) {
            args.addLogMessage(message);
        }
        args.add("--force", force);
        args.addAuthInfo(this.user, this.pass);
        args.addConfigInfo(this.configDir);
        return this.execString(args, false);
    }

    InputStream propget(String path, String propName) throws CmdLineException {
        this.setCommand(20, false);
        CommandLine.CmdArguments args = this.newCmdArguments("propget");
        args.add("--strict");
        args.add(propName);
        args.add(path);
        args.addAuthInfo(this.user, this.pass);
        args.addConfigInfo(this.configDir);
        return this.execInputStream(args);
    }

    InputStream propget(String path, String propName, String revision, String peg) throws CmdLineException {
        this.setCommand(20, false);
        CommandLine.CmdArguments args = this.newCmdArguments("propget");
        args.add("--strict");
        args.add("-r");
        args.add(revision);
        args.add(propName);
        args.add(path + "@" + peg);
        args.addAuthInfo(this.user, this.pass);
        args.addConfigInfo(this.configDir);
        return this.execInputStream(args);
    }

    void propset(String propName, String propValue, String target, boolean recurse) throws CmdLineException {
        this.setCommand(14, false);
        CommandLine.CmdArguments args = this.newCmdArguments("propset");
        args.add("-R", recurse);
        args.add(propName);
        args.add(propValue);
        args.add(target);
        args.addAuthInfo(this.user, this.pass);
        args.addConfigInfo(this.configDir);
        this.execVoid(args);
    }

    String proplist(String target, boolean recurse) throws CmdLineException {
        this.setCommand(21, false);
        CommandLine.CmdArguments args = this.newCmdArguments("proplist");
        args.add("-R", recurse);
        args.add(target);
        args.addAuthInfo(this.user, this.pass);
        args.addConfigInfo(this.configDir);
        return this.execString(args, false);
    }

    void propdel(String propName, String target, boolean recurse) throws CmdLineException {
        this.setCommand(15, true);
        CommandLine.CmdArguments args = this.newCmdArguments("propdel");
        args.add("-R", recurse);
        args.add(propName);
        args.add(target);
        args.addAuthInfo(this.user, this.pass);
        args.addConfigInfo(this.configDir);
        this.execVoid(args);
    }

    void propsetFile(String propName, String propFile, String target, boolean recurse) throws CmdLineException {
        this.setCommand(14, false);
        CommandLine.CmdArguments args = this.newCmdArguments("propset");
        args.add("-R", recurse);
        args.add(propName);
        args.add("-F");
        args.add(propFile);
        args.add(target);
        args.addAuthInfo(this.user, this.pass);
        args.addConfigInfo(this.configDir);
        this.execVoid(args);
    }

    String revert(String[] paths, boolean recursive) throws CmdLineException {
        this.setCommand(16, true);
        CommandLine.CmdArguments args = this.newCmdArguments("revert");
        args.add("-R", recursive);
        for (int i = 0; i < paths.length; ++i) {
            args.add(paths[i]);
        }
        args.addConfigInfo(this.configDir);
        return this.execString(args, false);
    }

    void resolved(String[] paths, boolean recursive) throws CmdLineException {
        this.setCommand(22, true);
        CommandLine.CmdArguments args = this.newCmdArguments("resolved");
        args.add("-R", recursive);
        for (int i = 0; i < paths.length; ++i) {
            args.add(paths[i]);
        }
        args.addConfigInfo(this.configDir);
        this.execVoid(args);
    }

    byte[] status(String[] path, boolean descend, boolean allEntries, boolean checkUpdates, boolean ignoreExternals) throws CmdLineException {
        if (path.length == 0) {
            return new byte[0];
        }
        this.setCommand(12, false);
        CommandLine.CmdArguments args = this.newCmdArguments("status");
        args.add("--xml");
        args.add("-v", allEntries);
        args.add("-N", !descend);
        args.add("-u", checkUpdates);
        args.add("--no-ignore", allEntries);
        args.add("--ignore-externals", ignoreExternals);
        for (int i = 0; i < path.length; ++i) {
            args.add(path[i]);
        }
        args.addAuthInfo(this.user, this.pass);
        args.addConfigInfo(this.configDir);
        return this.execBytes(args, false);
    }

    String update(String path, String revision) throws CmdLineException {
        this.setCommand(4, true);
        CommandLine.CmdArguments args = this.newCmdArguments("up");
        args.add("-r");
        args.add(SvnCommandLine.validRev(revision));
        args.add(path);
        args.addAuthInfo(this.user, this.pass);
        args.addConfigInfo(this.configDir);
        return this.execString(args, false);
    }

    String update(String[] paths, String revision) throws CmdLineException {
        StringBuffer pathsArg = new StringBuffer();
        for (int i = 0; i < paths.length; ++i) {
            pathsArg.append(paths[i]);
            pathsArg.append(" ");
        }
        this.setCommand(4, true);
        CommandLine.CmdArguments args = this.newCmdArguments("up");
        args.add("-r");
        args.add(SvnCommandLine.validRev(revision));
        args.add(pathsArg.toString());
        args.addAuthInfo(this.user, this.pass);
        args.addConfigInfo(this.configDir);
        return this.execString(args, false);
    }

    byte[] annotate(String path, String revisionStart, String revisionEnd) throws CmdLineException {
        this.setCommand(25, false);
        CommandLine.CmdArguments args = this.newCmdArguments("annotate");
        args.add("--xml");
        args.add("-r");
        if (revisionStart != null && revisionStart.length() > 0) {
            args.add(SvnCommandLine.validRev(revisionStart) + ":" + SvnCommandLine.validRev(revisionEnd));
        } else {
            args.add(SvnCommandLine.validRev(revisionEnd));
        }
        args.add(path);
        args.addAuthInfo(this.user, this.pass);
        args.addConfigInfo(this.configDir);
        return this.execBytes(args, false);
    }

    String switchUrl(String path, String url, String revision, boolean recurse) throws CmdLineException {
        this.setCommand(26, true);
        CommandLine.CmdArguments args = this.newCmdArguments("sw");
        args.add(url);
        args.add(path);
        args.add("-N", !recurse);
        args.add("-r");
        args.add(SvnCommandLine.validRev(revision));
        args.addAuthInfo(this.user, this.pass);
        args.addConfigInfo(this.configDir);
        return this.execString(args, false);
    }

    String relocate(String from, String to, String path, boolean recurse) throws CmdLineException {
        this.setCommand(30, false);
        CommandLine.CmdArguments args = this.newCmdArguments("sw");
        args.add("--relocate");
        args.add("-N", !recurse);
        args.add(from);
        args.add(to);
        args.add(path);
        args.addAuthInfo(this.user, this.pass);
        args.addConfigInfo(this.configDir);
        return this.execString(args, false);
    }

    String merge(String path1, String revision1, String path2, String revision2, String localPath, boolean force, boolean recurse, boolean dryRun, boolean ignoreAncestry) throws CmdLineException {
        this.setCommand(27, true);
        CommandLine.CmdArguments args = this.newCmdArguments("merge");
        args.add("-N", !recurse);
        args.add("--force", force);
        args.add("--ignore-ancestry", ignoreAncestry);
        args.add("--dry-run", dryRun);
        if (path1.equals(path2)) {
            args.add("-r");
            args.add(SvnCommandLine.validRev(revision1) + ":" + SvnCommandLine.validRev(revision2));
            args.add(path1);
        } else {
            args.add(path1 + "@" + SvnCommandLine.validRev(revision1));
            args.add(path2 + "@" + SvnCommandLine.validRev(revision2));
        }
        args.add(localPath);
        args.addAuthInfo(this.user, this.pass);
        args.addConfigInfo(this.configDir);
        return this.execString(args, false);
    }

    void revpropset(String propName, String propValue, String target, String revision, boolean force) throws CmdLineException {
        this.setCommand(14, false);
        CommandLine.CmdArguments args = this.newCmdArguments("propset");
        args.add(propName);
        args.add("--revprop");
        args.add(propValue);
        args.add(target);
        args.add("-r");
        args.add(revision);
        args.add("--force", force);
        args.addAuthInfo(this.user, this.pass);
        args.addConfigInfo(this.configDir);
        this.execVoid(args);
    }

    String lock(Object[] paths, String comment, boolean force) throws CmdLineException {
        this.setCommand(28, true);
        CommandLine.CmdArguments args = this.newCmdArguments("lock");
        args.add("--force", force);
        if (comment != null && !comment.equals("")) {
            args.add("-m");
            args.add(comment);
        }
        args.addAuthInfo(this.user, this.pass);
        args.addConfigInfo(this.configDir);
        for (int i = 0; i < paths.length; ++i) {
            args.add(paths[i]);
        }
        return this.execString(args, false);
    }

    String unlock(Object[] paths, boolean force) throws CmdLineException {
        this.setCommand(29, true);
        CommandLine.CmdArguments args = this.newCmdArguments("unlock");
        args.add("--force", force);
        args.addAuthInfo(this.user, this.pass);
        args.addConfigInfo(this.configDir);
        for (int i = 0; i < paths.length; ++i) {
            args.add(paths[i]);
        }
        return this.execString(args, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyFromSvnOutput(String svnOutput) {
        this.rev = -1L;
        super.notifyFromSvnOutput(svnOutput);
        if (this.parseSvnOutput) {
            CmdLineNotify notify = new CmdLineNotify(){

                public void onNotify(String path, int action, int kind, String mimeType, int contentState, int propState, long revision) {
                    if (path != null) {
                        SvnCommandLine.this.notificationHandler.notifyListenersOfChange(path);
                    }
                    if (revision != -1L) {
                        SvnCommandLine.this.rev = revision;
                        SvnCommandLine.this.notificationHandler.logRevision(revision, path);
                    }
                }
            };
            try {
                this.svnOutputParser.addListener(notify);
                this.svnOutputParser.parse(svnOutput);
            }
            finally {
                this.svnOutputParser.removeListener(notify);
            }
        }
    }

    protected void notifyMessagesFromSvnOutput(String svnOutput) {
        this.rev = -1L;
        super.notifyFromSvnOutput(svnOutput);
    }

    protected void setCommand(int command, boolean ouputIsNotification) {
        this.parseSvnOutput = ouputIsNotification;
        this.notificationHandler.setCommand(command);
    }

    public long getRevision() {
        return this.rev;
    }

    protected CommandLine.CmdArguments newCmdArguments(String command) {
        CommandLine.CmdArguments result = new CommandLine.CmdArguments();
        result.add(command);
        result.add("--no-auth-cache");
        return result;
    }
}

