/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.hsqldb.jdbc.JDBCColumnMetaData;
import org.hsqldb.jdbc.JDBCConnection;
import org.hsqldb.jdbc.Util;
import org.hsqldb.result.ResultMetaData;
import org.hsqldb.types.CharacterType;
import org.hsqldb.types.DateTimeType;
import org.hsqldb.types.IntervalType;
import org.hsqldb.types.Type;

public class JDBCResultSetMetaData
implements ResultSetMetaData {
    private ResultMetaData resultMetaData;
    private boolean useColumnName;
    private boolean translateTTIType;
    private int columnCount;

    @Override
    public int getColumnCount() throws SQLException {
        return this.resultMetaData.getColumnCount();
    }

    @Override
    public boolean isAutoIncrement(int n) throws SQLException {
        this.checkColumn(n);
        return this.resultMetaData.columns[--n].isIdentity();
    }

    @Override
    public boolean isCaseSensitive(int n) throws SQLException {
        this.checkColumn(n);
        Type type = this.translateType(this.resultMetaData.columnTypes[--n]);
        if (type.isCharacterType()) {
            return !((CharacterType)type).isCaseInsensitive();
        }
        return false;
    }

    @Override
    public boolean isSearchable(int n) throws SQLException {
        this.checkColumn(n);
        return this.resultMetaData.columns[--n].isSearchable();
    }

    @Override
    public boolean isCurrency(int n) throws SQLException {
        this.checkColumn(n);
        Type type = this.translateType(this.resultMetaData.columnTypes[--n]);
        return (type.typeCode == 3 || type.typeCode == 2) && type.scale > 0;
    }

    @Override
    public int isNullable(int n) throws SQLException {
        this.checkColumn(n);
        return this.resultMetaData.columns[--n].getNullability();
    }

    @Override
    public boolean isSigned(int n) throws SQLException {
        this.checkColumn(n);
        Type type = this.translateType(this.resultMetaData.columnTypes[--n]);
        return type.isNumberType();
    }

    @Override
    public int getColumnDisplaySize(int n) throws SQLException {
        this.checkColumn(n);
        Type type = this.translateType(this.resultMetaData.columnTypes[--n]);
        return type.displaySize();
    }

    @Override
    public String getColumnLabel(int n) throws SQLException {
        this.checkColumn(n--);
        String string = this.resultMetaData.columnLabels[n];
        if (string != null && string.length() > 0) {
            return string;
        }
        return this.resultMetaData.columns[n].getNameString();
    }

    @Override
    public String getColumnName(int n) throws SQLException {
        String string;
        this.checkColumn(n--);
        if (this.useColumnName && (string = this.resultMetaData.columns[n].getNameString()) != null && string.length() > 0) {
            return string;
        }
        string = this.resultMetaData.columnLabels[n];
        return string == null ? this.resultMetaData.columns[n].getNameString() : string;
    }

    @Override
    public String getSchemaName(int n) throws SQLException {
        this.checkColumn(n);
        String string = this.resultMetaData.columns[--n].getSchemaNameString();
        return string == null ? "" : string;
    }

    @Override
    public int getPrecision(int n) throws SQLException {
        this.checkColumn(n);
        Type type = this.translateType(this.resultMetaData.columnTypes[--n]);
        long l = type.precision;
        if (type.isDateTimeType() || type.isIntervalType()) {
            l = type.displaySize();
        }
        if (l > Integer.MAX_VALUE) {
            l = Integer.MAX_VALUE;
        }
        return (int)l;
    }

    @Override
    public int getScale(int n) throws SQLException {
        this.checkColumn(n);
        Type type = this.translateType(this.resultMetaData.columnTypes[--n]);
        return type.scale;
    }

    @Override
    public String getTableName(int n) throws SQLException {
        this.checkColumn(n);
        String string = this.resultMetaData.columns[--n].getTableNameString();
        return string == null ? "" : string;
    }

    @Override
    public String getCatalogName(int n) throws SQLException {
        this.checkColumn(n);
        String string = this.resultMetaData.columns[--n].getCatalogNameString();
        return string == null ? "" : string;
    }

    @Override
    public int getColumnType(int n) throws SQLException {
        this.checkColumn(n);
        Type type = this.translateType(this.resultMetaData.columnTypes[--n]);
        return type.getJDBCTypeCode();
    }

    @Override
    public String getColumnTypeName(int n) throws SQLException {
        this.checkColumn(n);
        Type type = this.translateType(this.resultMetaData.columnTypes[--n]);
        return type.getNameString();
    }

    @Override
    public boolean isReadOnly(int n) throws SQLException {
        this.checkColumn(n);
        return !this.resultMetaData.columns[--n].isWriteable();
    }

    @Override
    public boolean isWritable(int n) throws SQLException {
        this.checkColumn(n);
        return this.resultMetaData.colIndexes != null && this.resultMetaData.colIndexes[--n] > -1;
    }

    @Override
    public boolean isDefinitelyWritable(int n) throws SQLException {
        this.checkColumn(n);
        return this.resultMetaData.colIndexes != null && this.resultMetaData.colIndexes[--n] > -1;
    }

    @Override
    public String getColumnClassName(int n) throws SQLException {
        this.checkColumn(n);
        Type type = this.translateType(this.resultMetaData.columnTypes[--n]);
        return type.getJDBCClassName();
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        if (this.isWrapperFor(clazz)) {
            return (T)this;
        }
        throw Util.invalidArgument("iface: " + clazz);
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return clazz != null && clazz.isAssignableFrom(this.getClass());
    }

    JDBCResultSetMetaData(ResultMetaData resultMetaData, boolean bl, boolean bl2, JDBCConnection jDBCConnection) throws SQLException {
        this.init(resultMetaData, jDBCConnection);
    }

    void init(ResultMetaData resultMetaData, JDBCConnection jDBCConnection) throws SQLException {
        this.resultMetaData = resultMetaData;
        this.columnCount = this.resultMetaData.getColumnCount();
        this.useColumnName = true;
        if (jDBCConnection == null) {
            return;
        }
        if (jDBCConnection.connProperties != null) {
            this.useColumnName = jDBCConnection.connProperties.isPropertyTrue("get_column_name", true);
        }
        if (jDBCConnection.clientProperties != null) {
            this.translateTTIType = jDBCConnection.clientProperties.isPropertyTrue("jdbc.translate_tti_types");
        }
    }

    private void checkColumn(int n) throws SQLException {
        if (n < 1 || n > this.columnCount) {
            throw Util.sqlException(421, String.valueOf(n));
        }
    }

    private Type translateType(Type type) {
        if (this.translateTTIType) {
            if (type.isIntervalType()) {
                type = ((IntervalType)type).getCharacterType();
            } else if (type.isDateTimeTypeWithZone()) {
                type = ((DateTimeType)type).getDateTimeTypeWithoutZone();
            }
        }
        return type;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        if (this.columnCount == 0) {
            stringBuffer.append("[columnCount=0]");
            return stringBuffer.toString();
        }
        stringBuffer.append('[');
        for (int i = 0; i < this.columnCount; ++i) {
            JDBCColumnMetaData jDBCColumnMetaData = this.getColumnMetaData(i + 1);
            stringBuffer.append('\n');
            stringBuffer.append("   column_");
            stringBuffer.append(i + 1);
            stringBuffer.append('=');
            stringBuffer.append(jDBCColumnMetaData);
            if (i + 1 >= this.columnCount) continue;
            stringBuffer.append(',');
            stringBuffer.append(' ');
        }
        stringBuffer.append('\n');
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    JDBCColumnMetaData getColumnMetaData(int n) {
        JDBCColumnMetaData jDBCColumnMetaData = new JDBCColumnMetaData();
        try {
            jDBCColumnMetaData.catalogName = this.getCatalogName(n);
            jDBCColumnMetaData.columnClassName = this.getColumnClassName(n);
            jDBCColumnMetaData.columnDisplaySize = this.getColumnDisplaySize(n);
            jDBCColumnMetaData.columnLabel = this.getColumnLabel(n);
            jDBCColumnMetaData.columnName = this.getColumnName(n);
            jDBCColumnMetaData.columnType = this.getColumnType(n);
            jDBCColumnMetaData.isAutoIncrement = this.isAutoIncrement(n);
            jDBCColumnMetaData.isCaseSensitive = this.isCaseSensitive(n);
            jDBCColumnMetaData.isCurrency = this.isCurrency(n);
            jDBCColumnMetaData.isDefinitelyWritable = this.isDefinitelyWritable(n);
            jDBCColumnMetaData.isNullable = this.isNullable(n);
            jDBCColumnMetaData.isReadOnly = this.isReadOnly(n);
            jDBCColumnMetaData.isSearchable = this.isSearchable(n);
            jDBCColumnMetaData.isSigned = this.isSigned(n);
            jDBCColumnMetaData.isWritable = this.isWritable(n);
            jDBCColumnMetaData.precision = this.getPrecision(n);
            jDBCColumnMetaData.scale = this.getScale(n);
            jDBCColumnMetaData.schemaName = this.getSchemaName(n);
            jDBCColumnMetaData.tableName = this.getTableName(n);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return jDBCColumnMetaData;
    }
}

