/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.Constraint;
import org.hsqldb.Expression;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.ParserDDL;
import org.hsqldb.Routine;
import org.hsqldb.RoutineSchema;
import org.hsqldb.Row;
import org.hsqldb.Schema;
import org.hsqldb.SchemaManager;
import org.hsqldb.SchemaObject;
import org.hsqldb.Session;
import org.hsqldb.SqlInvariants;
import org.hsqldb.Statement;
import org.hsqldb.StatementDMQL;
import org.hsqldb.Table;
import org.hsqldb.TableWorks;
import org.hsqldb.Token;
import org.hsqldb.TriggerDef;
import org.hsqldb.View;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.result.Result;
import org.hsqldb.rights.Grantee;
import org.hsqldb.rights.GranteeManager;
import org.hsqldb.rights.Right;
import org.hsqldb.rights.User;
import org.hsqldb.store.ValuePool;
import org.hsqldb.types.Charset;
import org.hsqldb.types.Collation;
import org.hsqldb.types.Type;

public class StatementSchema
extends Statement {
    int order;
    Object[] arguments = ValuePool.emptyObjectArray;
    boolean isSchemaDefinition;
    Token[] statementTokens;

    StatementSchema(int n, int n2) {
        super(n, n2);
        this.isTransactionStatement = true;
    }

    StatementSchema(String string, int n) {
        this(string, n, null, null, null);
    }

    StatementSchema(String string, int n, Object[] objectArray) {
        this(string, n, objectArray, null, null);
    }

    StatementSchema(String string, int n, Object[] objectArray, HsqlNameManager.HsqlName[] hsqlNameArray, HsqlNameManager.HsqlName[] hsqlNameArray2) {
        super(n);
        this.isTransactionStatement = true;
        this.sql = string;
        if (objectArray != null) {
            this.arguments = objectArray;
        }
        if (hsqlNameArray != null) {
            this.readTableNames = hsqlNameArray;
        }
        if (hsqlNameArray2 != null) {
            this.writeTableNames = hsqlNameArray2;
        }
        switch (n) {
            case 1192: {
                this.group = 2002;
                break;
            }
            case 3: 
            case 4: 
            case 17: 
            case 60: 
            case 127: 
            case 134: 
            case 1069: 
            case 1070: {
                this.group = 2002;
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 78: 
            case 115: 
            case 116: 
            case 135: 
            case 1076: 
            case 1077: 
            case 1078: 
            case 1079: {
                this.group = 2002;
                break;
            }
            case 48: {
                this.group = 2002;
                this.order = 10;
                break;
            }
            case 49: {
                this.group = 2002;
                this.order = 10;
                break;
            }
            case 59: 
            case 129: {
                this.group = 2002;
                break;
            }
            case 64: {
                this.group = 2001;
                break;
            }
            case 61: {
                this.group = 2001;
                this.order = 1;
                break;
            }
            case 14: {
                this.group = 2001;
                this.order = 7;
                break;
            }
            case 133: {
                this.group = 2001;
                this.order = 1;
                break;
            }
            case 77: {
                this.group = 2001;
                this.order = 2;
                break;
            }
            case 117: {
                this.group = 2001;
                this.order = 1;
                break;
            }
            case 79: {
                this.group = 2001;
                this.order = 1;
                break;
            }
            case 80: {
                this.group = 2001;
                this.order = 7;
                break;
            }
            case 52: {
                this.group = 2001;
                this.order = 2;
                break;
            }
            case 83: {
                this.group = 2001;
                this.order = 1;
                break;
            }
            case 114: {
                this.group = 2001;
                this.order = 1;
                break;
            }
            case 84: {
                this.group = 2001;
                this.order = 5;
                break;
            }
            case 1074: {
                this.group = 2001;
                this.order = 1;
                break;
            }
            case 6: {
                this.group = 2001;
                this.order = 9;
                break;
            }
            case 8: {
                this.group = 2001;
                this.order = 1;
                break;
            }
            case 10: {
                this.group = 2001;
                this.order = 1;
                break;
            }
            case 23: {
                this.group = 2001;
                this.order = 1;
                break;
            }
            case 1072: {
                this.group = 2001;
                this.order = 8;
                break;
            }
            case 1073: {
                this.group = 2002;
                this.order = 4;
                break;
            }
            case 1071: {
                this.group = 2002;
                this.order = 11;
                break;
            }
            case 1204: {
                this.group = 2002;
                this.statementTokens = (Token[])objectArray[0];
                break;
            }
            case 1199: {
                this.group = 2002;
                break;
            }
            default: {
                throw Error.runtimeError(201, "StatemntSchema");
            }
        }
    }

    @Override
    public Result execute(Session session) {
        Result result;
        try {
            result = this.getResult(session);
        }
        catch (Throwable throwable) {
            result = Result.newErrorResult(throwable, null);
        }
        if (result.isError()) {
            result.getException().setStatementType(this.group, this.type);
            return result;
        }
        session.database.schemaManager.setSchemaChangeTimestamp();
        try {
            if (this.isLogged) {
                session.database.logger.writeOtherStatement(session, this.sql);
            }
        }
        catch (Throwable throwable) {
            return Result.newErrorResult(throwable, this.sql);
        }
        return result;
    }

    Result getResult(Session session) {
        SchemaManager schemaManager = session.database.schemaManager;
        if (this.isExplain) {
            return Result.newSingleColumnStringResult("OPERATION", this.describe(session));
        }
        block28 : switch (this.type) {
            case 1192: {
                HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)this.arguments[0];
                HsqlNameManager.HsqlName hsqlName2 = (HsqlNameManager.HsqlName)this.arguments[1];
                if (hsqlName.type == 1) {
                    try {
                        session.checkAdmin();
                        session.checkDDLWrite();
                        hsqlName.rename(hsqlName2);
                        break;
                    }
                    catch (HsqlException hsqlException) {
                        return Result.newErrorResult(hsqlException, this.sql);
                    }
                }
                if (hsqlName.type == 2) {
                    StatementSchema.checkSchemaUpdateAuthorisation(session, hsqlName);
                    schemaManager.checkSchemaNameCanChange(hsqlName);
                    schemaManager.renameSchema(hsqlName, hsqlName2);
                    break;
                }
                try {
                    SchemaObject schemaObject;
                    Object object;
                    hsqlName.setSchemaIfNull(session.getCurrentSchemaHsqlName());
                    if (hsqlName.type == 9) {
                        object = schemaManager.getUserTable(session, hsqlName.parent);
                        int n = ((Table)object).getColumnIndex(hsqlName.name);
                        schemaObject = ((Table)object).getColumn(n);
                    } else {
                        schemaObject = schemaManager.getSchemaObject(hsqlName);
                        if (schemaObject == null) {
                            throw Error.error(5501, hsqlName.name);
                        }
                        hsqlName = schemaObject.getName();
                    }
                    StatementSchema.checkSchemaUpdateAuthorisation(session, hsqlName.schema);
                    hsqlName2.setSchemaIfNull(hsqlName.schema);
                    if (hsqlName.schema != hsqlName2.schema) {
                        object = Error.error(5505);
                        return Result.newErrorResult((Throwable)object, this.sql);
                    }
                    hsqlName2.parent = hsqlName.parent;
                    switch (schemaObject.getType()) {
                        case 9: {
                            object = schemaObject.getName().parent;
                            schemaManager.checkColumnIsReferenced((HsqlNameManager.HsqlName)object, schemaObject.getName());
                            Table table = schemaManager.getUserTable(session, (HsqlNameManager.HsqlName)object);
                            table.renameColumn((ColumnSchema)schemaObject, hsqlName2);
                            break block28;
                        }
                    }
                    schemaManager.renameSchemaObject(hsqlName, hsqlName2);
                    break;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1069: {
                Table table = (Table)this.arguments[0];
                int[] nArray = (int[])this.arguments[1];
                HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)this.arguments[2];
                try {
                    Index index = (Index)session.database.schemaManager.getSchemaObject(hsqlName);
                    TableWorks tableWorks = new TableWorks(session, table);
                    tableWorks.alterIndex(index, nArray);
                    break;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 134: {
                try {
                    NumberSequence numberSequence = (NumberSequence)this.arguments[0];
                    NumberSequence numberSequence2 = (NumberSequence)this.arguments[1];
                    StatementSchema.checkSchemaUpdateAuthorisation(session, numberSequence.getSchemaName());
                    numberSequence.reset(numberSequence2);
                    break;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 3: {
                try {
                    int n = (Integer)this.arguments[0];
                    Type type = (Type)this.arguments[1];
                    switch (n) {
                        case 1082: {
                            Constraint constraint = (Constraint)this.arguments[2];
                            session.database.schemaManager.checkSchemaObjectNotExists(constraint.getName());
                            type.userTypeModifier.addConstraint(constraint);
                            session.database.schemaManager.addSchemaObject(constraint);
                            break;
                        }
                        case 1083: {
                            Expression expression = (Expression)this.arguments[2];
                            type.userTypeModifier.setDefaultClause(expression);
                            break;
                        }
                        case 1078: {
                            HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)this.arguments[2];
                            session.database.schemaManager.removeSchemaObject(hsqlName);
                            break;
                        }
                        case 1080: {
                            type.userTypeModifier.removeDefaultClause();
                        }
                    }
                    break;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 4: {
                try {
                    int n = (Integer)this.arguments[0];
                    Table table = (Table)this.arguments[1];
                    switch (n) {
                        case 1082: {
                            Constraint constraint = (Constraint)this.arguments[2];
                            switch (constraint.getConstraintType()) {
                                case 4: {
                                    TableWorks tableWorks = new TableWorks(session, table);
                                    tableWorks.addPrimaryKey(constraint);
                                    break block28;
                                }
                                case 2: {
                                    TableWorks tableWorks = new TableWorks(session, table);
                                    tableWorks.addUniqueConstraint(constraint);
                                    break block28;
                                }
                                case 0: {
                                    TableWorks tableWorks = new TableWorks(session, table);
                                    tableWorks.addForeignKey(constraint);
                                    break block28;
                                }
                                case 3: {
                                    TableWorks tableWorks = new TableWorks(session, table);
                                    tableWorks.addCheckConstraint(constraint);
                                    break block28;
                                }
                            }
                            break block28;
                        }
                        case 1081: {
                            ColumnSchema columnSchema = (ColumnSchema)this.arguments[2];
                            int n2 = (Integer)this.arguments[3];
                            HsqlArrayList hsqlArrayList = (HsqlArrayList)this.arguments[4];
                            TableWorks tableWorks = new TableWorks(session, table);
                            tableWorks.addColumn(columnSchema, n2, hsqlArrayList);
                            break block28;
                        }
                        case 1084: {
                            ColumnSchema columnSchema = (ColumnSchema)this.arguments[2];
                            Type type = (Type)this.arguments[3];
                            ColumnSchema columnSchema2 = columnSchema.duplicate();
                            columnSchema2.setType(type);
                            TableWorks tableWorks = new TableWorks(session, table);
                            tableWorks.retypeColumn(columnSchema, columnSchema2);
                            break block28;
                        }
                        case 1090: {
                            ColumnSchema columnSchema = (ColumnSchema)this.arguments[2];
                            Type type = (Type)this.arguments[3];
                            NumberSequence numberSequence = (NumberSequence)this.arguments[4];
                            ColumnSchema columnSchema3 = columnSchema.duplicate();
                            columnSchema3.setType(type);
                            columnSchema3.setIdentity(numberSequence);
                            TableWorks tableWorks = new TableWorks(session, table);
                            tableWorks.retypeColumn(columnSchema, columnSchema3);
                            break block28;
                        }
                        case 1085: {
                            ColumnSchema columnSchema = (ColumnSchema)this.arguments[2];
                            int n3 = (Integer)this.arguments[3];
                            NumberSequence numberSequence = (NumberSequence)this.arguments[4];
                            if (columnSchema.isIdentity()) {
                                columnSchema.getIdentitySequence().reset(numberSequence);
                                break block28;
                            }
                            columnSchema.setIdentity(numberSequence);
                            table.setColumnTypeVars(n3);
                            break block28;
                        }
                        case 1086: {
                            ColumnSchema columnSchema = (ColumnSchema)this.arguments[2];
                            boolean bl = (Boolean)this.arguments[3];
                            TableWorks tableWorks = new TableWorks(session, table);
                            tableWorks.setColNullability(columnSchema, bl);
                            break block28;
                        }
                        case 1087: {
                            ColumnSchema columnSchema = (ColumnSchema)this.arguments[2];
                            int n4 = (Integer)this.arguments[3];
                            Expression expression = (Expression)this.arguments[4];
                            TableWorks tableWorks = new TableWorks(session, table);
                            tableWorks.setColDefaultExpression(n4, expression);
                            break block28;
                        }
                        case 1088: {
                            ColumnSchema columnSchema = (ColumnSchema)this.arguments[2];
                            int n5 = (Integer)this.arguments[3];
                            TableWorks tableWorks = new TableWorks(session, table);
                            tableWorks.setColDefaultExpression(n5, null);
                            table.setColumnTypeVars(n5);
                            break block28;
                        }
                        case 1089: {
                            ColumnSchema columnSchema = (ColumnSchema)this.arguments[2];
                            int n6 = (Integer)this.arguments[3];
                            columnSchema.setIdentity(null);
                            table.setColumnTypeVars(n6);
                            break block28;
                        }
                    }
                    break;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 17: {
                Routine routine = (Routine)this.arguments[0];
                try {
                    routine.resolveReferences(session);
                    Routine routine2 = (Routine)schemaManager.getSchemaObject(routine.getSpecificName());
                    schemaManager.replaceReferences(routine2, routine);
                    routine2.setAsAlteredRoutine(routine);
                    break;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 60: 
            case 127: {
                throw Error.runtimeError(201, "StatementSchema");
            }
            case 1070: {
                View view = (View)this.arguments[0];
                try {
                    StatementSchema.checkSchemaUpdateAuthorisation(session, view.getSchemaName());
                    View view2 = (View)schemaManager.getSchemaObject(view.getName());
                    if (view2 == null) {
                        throw Error.error(5501, view.getName().name);
                    }
                    view.setName(view2.getName());
                    view.compile(session, null);
                    OrderedHashSet orderedHashSet = schemaManager.getReferencingObjectNames(view2.getName());
                    if (orderedHashSet.getCommonElementCount(view.getReferences()) > 0) {
                        throw Error.error(5502);
                    }
                    int n = schemaManager.getTableIndex(view2);
                    schemaManager.setTable(n, view);
                    OrderedHashSet orderedHashSet2 = new OrderedHashSet();
                    orderedHashSet2.add(view);
                    try {
                        schemaManager.recompileDependentObjects(orderedHashSet2);
                    }
                    catch (HsqlException hsqlException) {
                        schemaManager.setTable(n, view2);
                        schemaManager.recompileDependentObjects(orderedHashSet2);
                    }
                    break;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1076: {
                try {
                    HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)this.arguments[0];
                    int n = (Integer)this.arguments[1];
                    boolean bl = (Boolean)this.arguments[2];
                    boolean bl2 = (Boolean)this.arguments[3];
                    Table table = schemaManager.getUserTable(session, hsqlName.parent);
                    int n7 = table.getColumnIndex(hsqlName.name);
                    if (table.getColumnCount() == 1) {
                        throw Error.error(5591);
                    }
                    StatementSchema.checkSchemaUpdateAuthorisation(session, table.getSchemaName());
                    TableWorks tableWorks = new TableWorks(session, table);
                    tableWorks.dropColumn(n7, bl);
                    break;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 78: 
            case 115: 
            case 116: 
            case 135: 
            case 1077: 
            case 1078: 
            case 1079: {
                try {
                    HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)this.arguments[0];
                    int n = (Integer)this.arguments[1];
                    boolean bl = (Boolean)this.arguments[2];
                    boolean bl3 = (Boolean)this.arguments[3];
                    switch (this.type) {
                        case 29: 
                        case 1079: {
                            session.checkAdmin();
                            session.checkDDLWrite();
                            break;
                        }
                        case 31: {
                            StatementSchema.checkSchemaUpdateAuthorisation(session, hsqlName);
                            if (schemaManager.schemaExists(hsqlName.name) || !bl3) break;
                            return Result.updateZeroResult;
                        }
                        default: {
                            if (hsqlName.schema == null) {
                                hsqlName.schema = session.getCurrentSchemaHsqlName();
                            } else if (!schemaManager.schemaExists(hsqlName.schema.name) && bl3) {
                                return Result.updateZeroResult;
                            }
                            hsqlName.schema = schemaManager.getUserSchemaHsqlName(hsqlName.schema.name);
                            StatementSchema.checkSchemaUpdateAuthorisation(session, hsqlName.schema);
                            SchemaObject schemaObject = schemaManager.getSchemaObject(hsqlName);
                            if (schemaObject == null) {
                                if (bl3) {
                                    return Result.updateZeroResult;
                                }
                                throw Error.error(5501, hsqlName.name);
                            }
                            hsqlName = hsqlName.type == 24 ? ((Routine)schemaObject).getSpecificName() : schemaObject.getName();
                        }
                    }
                    if (!bl) {
                        schemaManager.checkObjectIsReferenced(hsqlName);
                    }
                    switch (this.type) {
                        case 29: {
                            StatementSchema.dropRole(session, hsqlName, bl);
                            break;
                        }
                        case 1079: {
                            StatementSchema.dropUser(session, hsqlName, bl);
                            break;
                        }
                        case 31: {
                            this.dropSchema(session, hsqlName, bl);
                            break;
                        }
                        case 24: {
                            break;
                        }
                        case 25: 
                        case 26: 
                        case 34: 
                        case 135: {
                            this.dropObject(session, hsqlName, bl);
                            break;
                        }
                        case 35: {
                            this.dropType(session, hsqlName, bl);
                            break;
                        }
                        case 27: {
                            StatementSchema.dropDomain(session, hsqlName, bl);
                            break;
                        }
                        case 30: {
                            this.dropRoutine(session, hsqlName, bl);
                            break;
                        }
                        case 32: 
                        case 36: {
                            this.dropTable(session, hsqlName, bl);
                            break;
                        }
                        case 33: 
                        case 78: 
                        case 115: 
                        case 116: {
                            break;
                        }
                        case 1077: {
                            StatementSchema.checkSchemaUpdateAuthorisation(session, hsqlName.schema);
                            schemaManager.dropIndex(session, hsqlName);
                            break;
                        }
                        case 1078: {
                            StatementSchema.checkSchemaUpdateAuthorisation(session, hsqlName.schema);
                            schemaManager.dropConstraint(session, hsqlName, bl);
                        }
                    }
                    break;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 48: 
            case 59: {
                try {
                    boolean bl = this.type == 48;
                    OrderedHashSet orderedHashSet = (OrderedHashSet)this.arguments[0];
                    HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)this.arguments[1];
                    this.setSchemaName(session, null, hsqlName);
                    hsqlName = schemaManager.getSchemaObjectName(hsqlName.schema, hsqlName.name, hsqlName.type, true);
                    SchemaObject schemaObject = schemaManager.getSchemaObject(hsqlName);
                    Right right = (Right)this.arguments[2];
                    Grantee grantee = (Grantee)this.arguments[3];
                    boolean bl4 = (Boolean)this.arguments[4];
                    boolean bl5 = (Boolean)this.arguments[5];
                    if (grantee == null) {
                        grantee = this.isSchemaDefinition ? this.schemaName.owner : session.getGrantee();
                    }
                    GranteeManager granteeManager = session.database.granteeManager;
                    switch (schemaObject.getType()) {
                        case 14: {
                            break;
                        }
                        case 3: 
                        case 4: {
                            Table table = (Table)schemaObject;
                            right.setColumns(table);
                            if (table.getTableType() != 3 || right.isFull()) break;
                            return Result.newErrorResult(Error.error(5595), this.sql);
                        }
                    }
                    if (bl) {
                        granteeManager.grant(orderedHashSet, schemaObject, right, grantee, bl5);
                        break;
                    }
                    granteeManager.revoke(orderedHashSet, schemaObject, right, grantee, bl5, bl4);
                    break;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 49: 
            case 129: {
                try {
                    String string;
                    int n;
                    boolean bl = this.type == 49;
                    OrderedHashSet orderedHashSet = (OrderedHashSet)this.arguments[0];
                    OrderedHashSet orderedHashSet3 = (OrderedHashSet)this.arguments[1];
                    Grantee grantee = (Grantee)this.arguments[2];
                    boolean bl6 = (Boolean)this.arguments[3];
                    GranteeManager granteeManager = session.database.granteeManager;
                    granteeManager.checkGranteeList(orderedHashSet);
                    for (n = 0; n < orderedHashSet.size(); ++n) {
                        string = (String)orderedHashSet.get(n);
                        granteeManager.checkRoleList(string, orderedHashSet3, grantee, bl);
                    }
                    if (bl) {
                        for (n = 0; n < orderedHashSet.size(); ++n) {
                            string = (String)orderedHashSet.get(n);
                            for (int i = 0; i < orderedHashSet3.size(); ++i) {
                                String string2 = (String)orderedHashSet3.get(i);
                                granteeManager.grant(string, string2, grantee);
                            }
                        }
                    } else {
                        for (n = 0; n < orderedHashSet.size(); ++n) {
                            string = (String)orderedHashSet.get(n);
                            for (int i = 0; i < orderedHashSet3.size(); ++i) {
                                granteeManager.revoke(string, (String)orderedHashSet3.get(i), grantee);
                            }
                        }
                    }
                    break;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 6: {
                return Result.updateZeroResult;
            }
            case 8: {
                Charset charset = (Charset)this.arguments[0];
                try {
                    this.setOrCheckObjectName(session, null, charset.getName(), true);
                    schemaManager.addSchemaObject(charset);
                    break;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 10: {
                Collation collation = (Collation)this.arguments[0];
                try {
                    this.setOrCheckObjectName(session, null, collation.getName(), true);
                    schemaManager.addSchemaObject(collation);
                    break;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 61: {
                try {
                    session.checkAdmin();
                    session.checkDDLWrite();
                    HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)this.arguments[0];
                    session.database.getGranteeManager().addRole(hsqlName);
                    break;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1074: {
                HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)this.arguments[0];
                String string = (String)this.arguments[1];
                Grantee grantee = (Grantee)this.arguments[2];
                boolean bl = (Boolean)this.arguments[3];
                boolean bl7 = (Boolean)this.arguments[4];
                try {
                    session.checkAdmin();
                    session.checkDDLWrite();
                    session.database.getUserManager().createUser(hsqlName, string, bl7);
                    if (!bl) break;
                    session.database.getGranteeManager().grant(hsqlName.name, "DBA", grantee);
                    break;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 64: {
                HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)this.arguments[0];
                Grantee grantee = (Grantee)this.arguments[1];
                try {
                    session.checkDDLWrite();
                    if (schemaManager.schemaExists(hsqlName.name)) {
                        if (session.isProcessingScript && "PUBLIC".equals(hsqlName.name)) break;
                        throw Error.error(5504, hsqlName.name);
                    }
                    schemaManager.createSchema(hsqlName, grantee);
                    Schema schema = schemaManager.findSchema(hsqlName.name);
                    this.sql = schema.getSQL();
                    if (!session.isProcessingScript() || !session.database.getProperties().isVersion18()) break;
                    session.setCurrentSchemaHsqlName(schema.getName());
                    break;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 14: {
                Routine routine = (Routine)this.arguments[0];
                try {
                    routine.resolve(session);
                    this.setOrCheckObjectName(session, null, routine.getName(), false);
                    schemaManager.addSchemaObject(routine);
                    break;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1072: {
                HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)this.arguments[0];
                Routine[] routineArray = (Routine[])this.arguments[1];
                try {
                    session.checkAdmin();
                    session.checkDDLWrite();
                    if (hsqlName == null) break;
                    for (int i = 0; i < routineArray.length; ++i) {
                        routineArray[i].setName(hsqlName);
                        schemaManager.addSchemaObject(routineArray[i]);
                    }
                    break;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 133: {
                NumberSequence numberSequence = (NumberSequence)this.arguments[0];
                try {
                    this.setOrCheckObjectName(session, null, numberSequence.getName(), true);
                    schemaManager.addSchemaObject(numberSequence);
                    break;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 23: {
                Type type = (Type)this.arguments[0];
                Constraint[] constraintArray = type.userTypeModifier.getConstraints();
                try {
                    this.setOrCheckObjectName(session, null, type.getName(), true);
                    for (int i = 0; i < constraintArray.length; ++i) {
                        Constraint constraint = constraintArray[i];
                        this.setOrCheckObjectName(session, type.getName(), constraint.getName(), true);
                        schemaManager.addSchemaObject(constraint);
                    }
                    schemaManager.addSchemaObject(type);
                    break;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 77: {
                Table table = (Table)this.arguments[0];
                HsqlArrayList hsqlArrayList = (HsqlArrayList)this.arguments[1];
                StatementDMQL statementDMQL = (StatementDMQL)this.arguments[2];
                Boolean bl = (Boolean)this.arguments[3];
                HsqlArrayList hsqlArrayList2 = null;
                try {
                    this.setOrCheckObjectName(session, null, table.getName(), true);
                }
                catch (HsqlException hsqlException) {
                    if (bl != null && bl.booleanValue()) {
                        return Result.updateZeroResult;
                    }
                    return Result.newErrorResult(hsqlException, this.sql);
                }
                try {
                    Object object;
                    if (this.isSchemaDefinition) {
                        hsqlArrayList2 = new HsqlArrayList();
                    }
                    if (hsqlArrayList.size() != 0) {
                        table = ParserDDL.addTableConstraintDefinitions(session, table, hsqlArrayList, hsqlArrayList2, true);
                        this.arguments[1] = hsqlArrayList2;
                    }
                    table.compile(session, null);
                    schemaManager.addSchemaObject(table);
                    if (statementDMQL != null) {
                        object = statementDMQL.execute(session);
                        table.insertIntoTable(session, (Result)object);
                    }
                    if (table.hasLobColumn) {
                        object = table.rowIterator(session);
                        while (object.hasNext()) {
                            Row row = object.getNextRow();
                            Object[] objectArray = row.getData();
                            session.sessionData.adjustLobUsageCount(table, objectArray, 1);
                        }
                    }
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    schemaManager.removeExportedKeys(table);
                    schemaManager.removeDependentObjects(table.getName());
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 117: {
                return Result.updateZeroResult;
            }
            case 79: {
                return Result.updateZeroResult;
            }
            case 80: {
                TriggerDef triggerDef = (TriggerDef)this.arguments[0];
                HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)this.arguments[1];
                try {
                    StatementSchema.checkSchemaUpdateAuthorisation(session, triggerDef.getSchemaName());
                    schemaManager.checkSchemaObjectNotExists(triggerDef.getName());
                    if (hsqlName != null && schemaManager.getSchemaObject(hsqlName) == null) {
                        throw Error.error(5501, hsqlName.name);
                    }
                    triggerDef.table.addTrigger(triggerDef, hsqlName);
                    schemaManager.addSchemaObject(triggerDef);
                    break;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 52: {
                return Result.updateZeroResult;
            }
            case 83: {
                Type type = (Type)this.arguments[0];
                try {
                    this.setOrCheckObjectName(session, null, type.getName(), true);
                    schemaManager.addSchemaObject(type);
                    break;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 114: {
                return Result.updateZeroResult;
            }
            case 84: {
                View view = (View)this.arguments[0];
                try {
                    StatementSchema.checkSchemaUpdateAuthorisation(session, view.getSchemaName());
                    schemaManager.checkSchemaObjectNotExists(view.getName());
                    view.compile(session, null);
                    schemaManager.addSchemaObject(view);
                    break;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1073: {
                Table table = (Table)this.arguments[0];
                int[] nArray = (int[])this.arguments[1];
                HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)this.arguments[2];
                boolean bl = (Boolean)this.arguments[3];
                try {
                    this.setOrCheckObjectName(session, table.getName(), hsqlName, true);
                    TableWorks tableWorks = new TableWorks(session, table);
                    tableWorks.addIndex(nArray, hsqlName, bl);
                    break;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1071: {
                HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)this.arguments[0];
                String string = (String)this.arguments[1];
                switch (hsqlName.type) {
                    case 9: {
                        Table table = (Table)schemaManager.getSchemaObject(hsqlName.parent.name, hsqlName.parent.schema.name, 3);
                        if (!session.getGrantee().isFullyAccessibleByRole(table.getName())) {
                            throw Error.error(5501);
                        }
                        int n = table.getColumnIndex(hsqlName.name);
                        if (n < 0) {
                            throw Error.error(5501);
                        }
                        ColumnSchema columnSchema = table.getColumn(n);
                        columnSchema.getName().comment = string;
                        break block28;
                    }
                    case 18: {
                        RoutineSchema routineSchema = (RoutineSchema)schemaManager.getSchemaObject(hsqlName.name, hsqlName.schema.name, 18);
                        if (!session.getGrantee().isFullyAccessibleByRole(routineSchema.getName())) {
                            throw Error.error(5501);
                        }
                        routineSchema.getName().comment = string;
                        break block28;
                    }
                    case 3: {
                        Table table = (Table)schemaManager.getSchemaObject(hsqlName.name, hsqlName.schema.name, 3);
                        if (!session.getGrantee().isFullyAccessibleByRole(table.getName())) {
                            throw Error.error(5501);
                        }
                        table.getName().comment = string;
                        break block28;
                    }
                }
                break;
            }
            case 1199: {
                break;
            }
            default: {
                throw Error.runtimeError(201, "StatementSchema");
            }
        }
        return Result.updateZeroResult;
    }

    private void dropType(Session session, HsqlNameManager.HsqlName hsqlName, boolean bl) {
        StatementSchema.checkSchemaUpdateAuthorisation(session, hsqlName.schema);
        Type type = (Type)session.database.schemaManager.getSchemaObject(hsqlName);
        session.database.schemaManager.removeSchemaObject(hsqlName, bl);
        type.userTypeModifier = null;
    }

    private static void dropDomain(Session session, HsqlNameManager.HsqlName hsqlName, boolean bl) {
        Type type = (Type)session.database.schemaManager.getSchemaObject(hsqlName);
        OrderedHashSet orderedHashSet = session.database.schemaManager.getReferencingObjectNames(type.getName());
        if (!bl && orderedHashSet.size() > 0) {
            HsqlNameManager.HsqlName hsqlName2 = (HsqlNameManager.HsqlName)orderedHashSet.get(0);
            throw Error.error(5502, hsqlName2.getSchemaQualifiedStatementName());
        }
        Constraint[] constraintArray = type.userTypeModifier.getConstraints();
        orderedHashSet = new OrderedHashSet();
        for (int i = 0; i < constraintArray.length; ++i) {
            orderedHashSet.add(constraintArray[i].getName());
        }
        session.database.schemaManager.removeSchemaObjects(orderedHashSet);
        session.database.schemaManager.removeSchemaObject(type.getName(), bl);
        type.userTypeModifier = null;
    }

    private static void dropRole(Session session, HsqlNameManager.HsqlName hsqlName, boolean bl) {
        Grantee grantee = session.database.getGranteeManager().getRole(hsqlName.name);
        if (!bl && session.database.schemaManager.hasSchemas(grantee)) {
            HsqlArrayList hsqlArrayList = session.database.schemaManager.getSchemas(grantee);
            Schema schema = (Schema)hsqlArrayList.get(0);
            throw Error.error(5502, schema.getName().statementName);
        }
        session.database.schemaManager.dropSchemas(session, grantee, bl);
        session.database.getGranteeManager().dropRole(hsqlName.name);
    }

    private static void dropUser(Session session, HsqlNameManager.HsqlName hsqlName, boolean bl) {
        User user = session.database.getUserManager().get(hsqlName.name);
        if (session.database.getSessionManager().isUserActive(hsqlName.name)) {
            throw Error.error(5539);
        }
        if (!bl && session.database.schemaManager.hasSchemas(user)) {
            HsqlArrayList hsqlArrayList = session.database.schemaManager.getSchemas(user);
            Schema schema = (Schema)hsqlArrayList.get(0);
            throw Error.error(5502, schema.getName().statementName);
        }
        session.database.schemaManager.dropSchemas(session, user, bl);
        session.database.getUserManager().dropUser(hsqlName.name);
    }

    private void dropSchema(Session session, HsqlNameManager.HsqlName hsqlName, boolean bl) {
        HsqlNameManager.HsqlName hsqlName2 = session.database.schemaManager.getUserSchemaHsqlName(hsqlName.name);
        StatementSchema.checkSchemaUpdateAuthorisation(session, hsqlName2);
        session.database.schemaManager.dropSchema(session, hsqlName.name, bl);
    }

    private void dropRoutine(Session session, HsqlNameManager.HsqlName hsqlName, boolean bl) {
        StatementSchema.checkSchemaUpdateAuthorisation(session, hsqlName.schema);
        session.database.schemaManager.removeSchemaObject(hsqlName, bl);
    }

    private void dropObject(Session session, HsqlNameManager.HsqlName hsqlName, boolean bl) {
        hsqlName = session.database.schemaManager.getSchemaObjectName(hsqlName.schema, hsqlName.name, hsqlName.type, true);
        session.database.schemaManager.removeSchemaObject(hsqlName, bl);
    }

    private void dropTable(Session session, HsqlNameManager.HsqlName hsqlName, boolean bl) {
        Table table = session.database.schemaManager.findUserTable(session, hsqlName.name, hsqlName.schema.name);
        session.database.schemaManager.dropTableOrView(session, table, bl);
    }

    static void checkSchemaUpdateAuthorisation(Session session, HsqlNameManager.HsqlName hsqlName) {
        if (session.isProcessingLog) {
            return;
        }
        if (SqlInvariants.isSystemSchemaName(hsqlName.name)) {
            throw Error.error(5503);
        }
        if (session.parser.isSchemaDefinition) {
            if (hsqlName == session.getCurrentSchemaHsqlName()) {
                return;
            }
            Error.error(5505, hsqlName.name);
        }
        session.getGrantee().checkSchemaUpdateOrGrantRights(hsqlName.name);
        session.checkDDLWrite();
    }

    void setOrCheckObjectName(Session session, HsqlNameManager.HsqlName hsqlName, HsqlNameManager.HsqlName hsqlName2, boolean bl) {
        if (hsqlName2.schema == null) {
            hsqlName2.schema = this.schemaName == null ? session.getCurrentSchemaHsqlName() : this.schemaName;
        } else {
            hsqlName2.schema = session.getSchemaHsqlName(hsqlName2.schema.name);
            if (hsqlName2.schema == null) {
                throw Error.error(5505);
            }
            if (this.isSchemaDefinition && this.schemaName != hsqlName2.schema) {
                throw Error.error(5505);
            }
        }
        hsqlName2.parent = hsqlName;
        if (!this.isSchemaDefinition) {
            StatementSchema.checkSchemaUpdateAuthorisation(session, hsqlName2.schema);
        }
        if (bl) {
            session.database.schemaManager.checkSchemaObjectNotExists(hsqlName2);
        }
    }

    void setSchemaName(Session session, HsqlNameManager.HsqlName hsqlName, HsqlNameManager.HsqlName hsqlName2) {
        if (hsqlName2.schema == null) {
            hsqlName2.schema = this.schemaName == null ? session.getCurrentSchemaHsqlName() : this.schemaName;
        } else {
            hsqlName2.schema = session.getSchemaHsqlName(hsqlName2.schema.name);
            if (hsqlName2.schema == null) {
                throw Error.error(5505);
            }
            if (this.isSchemaDefinition && this.schemaName != hsqlName2.schema) {
                throw Error.error(5505);
            }
        }
    }

    @Override
    public boolean isAutoCommitStatement() {
        return true;
    }

    @Override
    public String describe(Session session) {
        return this.sql;
    }

    public Object[] getArguments() {
        return this.arguments;
    }
}

