/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.svg.graphic;

import com.itextpdf.text.Element;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.tool.xml.svg.graphic.CssSvgAppliers;
import com.itextpdf.tool.xml.svg.graphic.Text;
import com.itextpdf.tool.xml.svg.tags.Graphic;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextGroup
extends Graphic {
    final List<Element> list;
    final float width;
    final float height;
    final float x;
    final float y;

    public TextGroup(List<Element> list, float x, float y, float width, float height, Map<String, String> css) {
        super(css);
        this.list = list;
        this.width = width;
        this.height = height;
        this.x = x;
        this.y = y;
    }

    void drawGroup(PdfContentByte cb) {
        PdfTemplate template = cb.createTemplate(500.0f, 500.0f);
        List<Integer> xSpacing = null;
        List<Integer> ySpacing = null;
        float defaultSpacing = template.getCharacterSpacing();
        float rise = 0.0f;
        template.beginText();
        for (Element elem : this.list) {
            Text text = (Text)elem;
            CssSvgAppliers.getInstance().applyForText((PdfContentByte)template, text.getCss(), text.getChunk());
            if (!text.isRelative()) {
                template.setTextMatrix(text.getX(), -1.0f * text.getY());
            }
            if (text.getDx() != null) {
                xSpacing = text.getDx();
            }
            if (text.getDy() != null) {
                ySpacing = text.getDy();
                rise = 0.0f;
            }
            if (xSpacing != null || ySpacing != null) {
                String display = text.getText();
                for (int i = 0; i < display.length(); ++i) {
                    if (xSpacing != null && xSpacing.size() > 0) {
                        template.setCharacterSpacing((float)xSpacing.get(0).intValue());
                        xSpacing.remove(0);
                    }
                    if (ySpacing != null && ySpacing.size() > 0) {
                        template.setTextRise(rise -= (float)ySpacing.get(0).intValue());
                        ySpacing.remove(0);
                    } else {
                        template.setTextRise(rise);
                    }
                    template.showText(display.substring(i, i + 1));
                    template.setCharacterSpacing(defaultSpacing);
                }
                continue;
            }
            template.showText(text.getText());
        }
        template.endText();
        cb.concatCTM(1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f);
        cb.add((PdfContentByte)template);
    }

    @Override
    public void draw(PdfContentByte cb) {
        this.drawGroup(cb);
    }
}

