/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma.report.html.doc;

import com.vladium.emma.report.html.doc.Attribute;
import com.vladium.emma.report.html.doc.AttributeSet;
import com.vladium.emma.report.html.doc.HTMLWriter;
import com.vladium.emma.report.html.doc.IContent;
import com.vladium.emma.report.html.doc.Tag;

public interface ISimpleElement
extends IContent {
    public Tag getTag();

    public ISimpleElement setClass(String var1);

    public AttributeSet getAttributes();

    public static abstract class Factory {
        public static ISimpleElement create(Tag tag) {
            return new SimpleElementImpl(tag, AttributeSet.create());
        }

        public static ISimpleElement create(Tag tag, AttributeSet attrs) {
            return new SimpleElementImpl(tag, attrs);
        }

        static class SimpleElementImpl
        implements ISimpleElement {
            protected final Tag m_tag;
            protected final AttributeSet m_attrs;

            public String toString() {
                return "<" + this.m_tag.getName() + "/>";
            }

            public Tag getTag() {
                return this.m_tag;
            }

            public ISimpleElement setClass(String classID) {
                if (classID != null && classID.length() > 0) {
                    this.getAttributes().set(Attribute.CLASS, classID);
                }
                return this;
            }

            public AttributeSet getAttributes() {
                return this.m_attrs;
            }

            public void emit(HTMLWriter out) {
                out.write('<');
                out.write(this.m_tag.getName());
                if (!this.m_attrs.isEmpty()) {
                    out.write(' ');
                    this.m_attrs.emit(out);
                }
                out.write("/>");
            }

            SimpleElementImpl(Tag tag, AttributeSet attrs) {
                this.m_tag = tag;
                this.m_attrs = attrs;
            }
        }
    }
}

