/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.joda.time;

import com.google.appengine.repackaged.org.joda.time.Chronology;
import com.google.appengine.repackaged.org.joda.time.DateTime;
import com.google.appengine.repackaged.org.joda.time.DateTimeField;
import com.google.appengine.repackaged.org.joda.time.DateTimeFieldType;
import com.google.appengine.repackaged.org.joda.time.DateTimeUtils;
import com.google.appengine.repackaged.org.joda.time.DateTimeZone;
import com.google.appengine.repackaged.org.joda.time.DurationFieldType;
import com.google.appengine.repackaged.org.joda.time.Interval;
import com.google.appengine.repackaged.org.joda.time.LocalDate;
import com.google.appengine.repackaged.org.joda.time.ReadableInstant;
import com.google.appengine.repackaged.org.joda.time.ReadablePartial;
import com.google.appengine.repackaged.org.joda.time.ReadablePeriod;
import com.google.appengine.repackaged.org.joda.time.base.BasePartial;
import com.google.appengine.repackaged.org.joda.time.chrono.ISOChronology;
import com.google.appengine.repackaged.org.joda.time.field.AbstractPartialFieldProperty;
import com.google.appengine.repackaged.org.joda.time.field.FieldUtils;
import com.google.appengine.repackaged.org.joda.time.format.DateTimeFormat;
import com.google.appengine.repackaged.org.joda.time.format.DateTimeFormatter;
import com.google.appengine.repackaged.org.joda.time.format.ISODateTimeFormat;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.joda.convert.FromString;
import org.joda.convert.ToString;

public final class YearMonth
extends BasePartial
implements ReadablePartial,
Serializable {
    private static final long serialVersionUID = 797544782896179L;
    private static final DateTimeFieldType[] FIELD_TYPES = new DateTimeFieldType[]{DateTimeFieldType.year(), DateTimeFieldType.monthOfYear()};
    public static final int YEAR = 0;
    public static final int MONTH_OF_YEAR = 1;

    public static YearMonth now() {
        return new YearMonth();
    }

    public static YearMonth now(DateTimeZone zone) {
        if (zone == null) {
            throw new NullPointerException("Zone must not be null");
        }
        return new YearMonth(zone);
    }

    public static YearMonth now(Chronology chronology) {
        if (chronology == null) {
            throw new NullPointerException("Chronology must not be null");
        }
        return new YearMonth(chronology);
    }

    @FromString
    public static YearMonth parse(String str) {
        return YearMonth.parse(str, ISODateTimeFormat.localDateParser());
    }

    public static YearMonth parse(String str, DateTimeFormatter formatter) {
        LocalDate date = formatter.parseLocalDate(str);
        return new YearMonth(date.getYear(), date.getMonthOfYear());
    }

    public static YearMonth fromCalendarFields(Calendar calendar) {
        if (calendar == null) {
            throw new IllegalArgumentException("The calendar must not be null");
        }
        return new YearMonth(calendar.get(1), calendar.get(2) + 1);
    }

    public static YearMonth fromDateFields(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        return new YearMonth(date.getYear() + 1900, date.getMonth() + 1);
    }

    public YearMonth() {
    }

    public YearMonth(DateTimeZone zone) {
        super(ISOChronology.getInstance(zone));
    }

    public YearMonth(Chronology chronology) {
        super(chronology);
    }

    public YearMonth(long instant) {
        super(instant);
    }

    public YearMonth(long instant, Chronology chronology) {
        super(instant, chronology);
    }

    public YearMonth(Object instant) {
        super(instant, null, ISODateTimeFormat.localDateParser());
    }

    public YearMonth(Object instant, Chronology chronology) {
        super(instant, DateTimeUtils.getChronology(chronology), ISODateTimeFormat.localDateParser());
    }

    public YearMonth(int year, int monthOfYear) {
        this(year, monthOfYear, null);
    }

    public YearMonth(int year, int monthOfYear, Chronology chronology) {
        super(new int[]{year, monthOfYear}, chronology);
    }

    YearMonth(YearMonth partial, int[] values) {
        super((BasePartial)partial, values);
    }

    YearMonth(YearMonth partial, Chronology chrono) {
        super((BasePartial)partial, chrono);
    }

    private Object readResolve() {
        if (!DateTimeZone.UTC.equals(this.getChronology().getZone())) {
            return new YearMonth(this, this.getChronology().withUTC());
        }
        return this;
    }

    @Override
    public int size() {
        return 2;
    }

    @Override
    protected DateTimeField getField(int index, Chronology chrono) {
        switch (index) {
            case 0: {
                return chrono.year();
            }
            case 1: {
                return chrono.monthOfYear();
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + index);
    }

    @Override
    public DateTimeFieldType getFieldType(int index) {
        return FIELD_TYPES[index];
    }

    @Override
    public DateTimeFieldType[] getFieldTypes() {
        return (DateTimeFieldType[])FIELD_TYPES.clone();
    }

    public YearMonth withChronologyRetainFields(Chronology newChronology) {
        newChronology = DateTimeUtils.getChronology(newChronology);
        if ((newChronology = newChronology.withUTC()) == this.getChronology()) {
            return this;
        }
        YearMonth newYearMonth = new YearMonth(this, newChronology);
        newChronology.validate(newYearMonth, this.getValues());
        return newYearMonth;
    }

    public YearMonth withField(DateTimeFieldType fieldType, int value) {
        int index = this.indexOfSupported(fieldType);
        if (value == this.getValue(index)) {
            return this;
        }
        int[] newValues = this.getValues();
        newValues = this.getField(index).set(this, index, newValues, value);
        return new YearMonth(this, newValues);
    }

    public YearMonth withFieldAdded(DurationFieldType fieldType, int amount) {
        int index = this.indexOfSupported(fieldType);
        if (amount == 0) {
            return this;
        }
        int[] newValues = this.getValues();
        newValues = this.getField(index).add(this, index, newValues, amount);
        return new YearMonth(this, newValues);
    }

    public YearMonth withPeriodAdded(ReadablePeriod period, int scalar) {
        if (period == null || scalar == 0) {
            return this;
        }
        int[] newValues = this.getValues();
        for (int i = 0; i < period.size(); ++i) {
            DurationFieldType fieldType = period.getFieldType(i);
            int index = this.indexOf(fieldType);
            if (index < 0) continue;
            newValues = this.getField(index).add(this, index, newValues, FieldUtils.safeMultiply(period.getValue(i), scalar));
        }
        return new YearMonth(this, newValues);
    }

    public YearMonth plus(ReadablePeriod period) {
        return this.withPeriodAdded(period, 1);
    }

    public YearMonth plusYears(int years) {
        return this.withFieldAdded(DurationFieldType.years(), years);
    }

    public YearMonth plusMonths(int months) {
        return this.withFieldAdded(DurationFieldType.months(), months);
    }

    public YearMonth minus(ReadablePeriod period) {
        return this.withPeriodAdded(period, -1);
    }

    public YearMonth minusYears(int years) {
        return this.withFieldAdded(DurationFieldType.years(), FieldUtils.safeNegate(years));
    }

    public YearMonth minusMonths(int months) {
        return this.withFieldAdded(DurationFieldType.months(), FieldUtils.safeNegate(months));
    }

    public LocalDate toLocalDate(int dayOfMonth) {
        return new LocalDate(this.getYear(), this.getMonthOfYear(), dayOfMonth, this.getChronology());
    }

    public Interval toInterval() {
        return this.toInterval(null);
    }

    public Interval toInterval(DateTimeZone zone) {
        zone = DateTimeUtils.getZone(zone);
        DateTime start = this.toLocalDate(1).toDateTimeAtStartOfDay(zone);
        DateTime end = this.plusMonths(1).toLocalDate(1).toDateTimeAtStartOfDay(zone);
        return new Interval((ReadableInstant)start, (ReadableInstant)end);
    }

    public int getYear() {
        return this.getValue(0);
    }

    public int getMonthOfYear() {
        return this.getValue(1);
    }

    public YearMonth withYear(int year) {
        int[] newValues = this.getValues();
        newValues = this.getChronology().year().set(this, 0, newValues, year);
        return new YearMonth(this, newValues);
    }

    public YearMonth withMonthOfYear(int monthOfYear) {
        int[] newValues = this.getValues();
        newValues = this.getChronology().monthOfYear().set(this, 1, newValues, monthOfYear);
        return new YearMonth(this, newValues);
    }

    public Property property(DateTimeFieldType type) {
        return new Property(this, this.indexOfSupported(type));
    }

    public Property year() {
        return new Property(this, 0);
    }

    public Property monthOfYear() {
        return new Property(this, 1);
    }

    @Override
    @ToString
    public String toString() {
        return ISODateTimeFormat.yearMonth().print(this);
    }

    @Override
    public String toString(String pattern) {
        if (pattern == null) {
            return this.toString();
        }
        return DateTimeFormat.forPattern(pattern).print(this);
    }

    @Override
    public String toString(String pattern, Locale locale) throws IllegalArgumentException {
        if (pattern == null) {
            return this.toString();
        }
        return DateTimeFormat.forPattern(pattern).withLocale(locale).print(this);
    }

    public static class Property
    extends AbstractPartialFieldProperty
    implements Serializable {
        private static final long serialVersionUID = 5727734012190224363L;
        private final YearMonth iBase;
        private final int iFieldIndex;

        Property(YearMonth partial, int fieldIndex) {
            this.iBase = partial;
            this.iFieldIndex = fieldIndex;
        }

        @Override
        public DateTimeField getField() {
            return this.iBase.getField(this.iFieldIndex);
        }

        @Override
        protected ReadablePartial getReadablePartial() {
            return this.iBase;
        }

        public YearMonth getYearMonth() {
            return this.iBase;
        }

        @Override
        public int get() {
            return this.iBase.getValue(this.iFieldIndex);
        }

        public YearMonth addToCopy(int valueToAdd) {
            int[] newValues = this.iBase.getValues();
            newValues = this.getField().add(this.iBase, this.iFieldIndex, newValues, valueToAdd);
            return new YearMonth(this.iBase, newValues);
        }

        public YearMonth addWrapFieldToCopy(int valueToAdd) {
            int[] newValues = this.iBase.getValues();
            newValues = this.getField().addWrapField(this.iBase, this.iFieldIndex, newValues, valueToAdd);
            return new YearMonth(this.iBase, newValues);
        }

        public YearMonth setCopy(int value) {
            int[] newValues = this.iBase.getValues();
            newValues = this.getField().set(this.iBase, this.iFieldIndex, newValues, value);
            return new YearMonth(this.iBase, newValues);
        }

        public YearMonth setCopy(String text, Locale locale) {
            int[] newValues = this.iBase.getValues();
            newValues = this.getField().set(this.iBase, this.iFieldIndex, newValues, text, locale);
            return new YearMonth(this.iBase, newValues);
        }

        public YearMonth setCopy(String text) {
            return this.setCopy(text, null);
        }
    }
}

